/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class InputStreamUtil {
    private InputStreamUtil() {
    }

    public static String streamToString(InputStream input) throws IOException {
        if (input != null) {
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
                String string = buffer.lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        return "";
    }

    public static String streamToBoundedString(InputStream input, long maxLength) throws IOException {
        if (input != null && maxLength > 0L) {
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((bytesRead = input.read(bytes)) != -1) {
                int bytesToCopy = (int)Math.min((long)bytesRead, maxLength - (long)buffer.size());
                buffer.write(bytes, 0, bytesToCopy);
                if ((long)buffer.size() < maxLength) continue;
                PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.WARNING, "Input truncated at " + maxLength, null);
                break;
            }
            buffer.flush();
            return buffer.toString(StandardCharsets.UTF_8.name());
        }
        return "";
    }
}

