/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import com.tridiumeurope.httpClient.BHttpClient;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.datatypes.options.BAddOptionDetail;
import com.tridiumeurope.httpClient.driver.point.BHttpClientProxyExt;
import com.tridiumeurope.httpClient.util.BIHttpConsumer;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.HttpConsumable;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="captureAll", type="boolean", defaultValue="false"), @NiagaraProperty(name="concatDuplicates", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="add", parameterType="BAddOptionDetail", defaultValue="new BAddOptionDetail()"), @NiagaraAction(name="clearAll"), @NiagaraAction(name="reset"), @NiagaraAction(name="convertToPassword", parameterType="BString", defaultValue="BString.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"httpClient:PropertyPickerFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"httpClient:PropertyPicker\"")})})
public class BResponseHeaderCapture
extends BComponent
implements BIHttpConsumer {
    public static final Property captureAll = BResponseHeaderCapture.newProperty((int)0, (boolean)false, null);
    public static final Property concatDuplicates = BResponseHeaderCapture.newProperty((int)0, (boolean)true, null);
    public static final Action add = BResponseHeaderCapture.newAction((int)0, (BValue)new BAddOptionDetail(), null);
    public static final Action clearAll = BResponseHeaderCapture.newAction((int)0, null);
    public static final Action reset = BResponseHeaderCapture.newAction((int)0, null);
    public static final Action convertToPassword = BResponseHeaderCapture.newAction((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"httpClient:PropertyPickerFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"httpClient:PropertyPicker")));
    public static final Type TYPE = Sys.loadType(BResponseHeaderCapture.class);
    protected final Map<String, String> captureValues = new HashMap<String, String>();
    private static final BIcon ICON = BIcon.std((String)"control/control.png");

    public boolean getCaptureAll() {
        return this.getBoolean(captureAll);
    }

    public void setCaptureAll(boolean v) {
        this.setBoolean(captureAll, v, null);
    }

    public boolean getConcatDuplicates() {
        return this.getBoolean(concatDuplicates);
    }

    public void setConcatDuplicates(boolean v) {
        this.setBoolean(concatDuplicates, v, null);
    }

    public void add(BAddOptionDetail parameter) {
        this.invoke(add, (BValue)parameter, null);
    }

    public void clearAll() {
        this.invoke(clearAll, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void convertToPassword(BString parameter) {
        this.invoke(convertToPassword, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BHttpClient || parent instanceof BHttpClientProxyExt;
    }

    public void doAdd(BAddOptionDetail detail) {
        PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Adding " + detail.getSlotName() + ' ' + (Object)((Object)detail.getSlotType()), (Object)this);
        this.add(SlotPath.escape((String)detail.getSlotName()), (BValue)detail.getSlotDefaultValue());
    }

    public void doClearAll() {
        Arrays.stream(this.getDynamicPropertiesArray()).forEach(property -> this.set((Property)property, (BValue)(this.get((Property)property) instanceof BPassword ? BPassword.DEFAULT : BString.DEFAULT)));
    }

    public void doReset() {
        this.removeAll();
    }

    public void doConvertToPassword(BString slotName) {
        if (slotName.equals((Object)BString.DEFAULT) || slotName.getString().contains(",")) {
            return;
        }
        String safeName = SlotPath.escape((String)slotName.getString());
        BValue existing = this.get(safeName);
        if (existing == null) {
            throw new IllegalArgumentException("Header property not found: " + safeName);
        }
        this.set(safeName, (BValue)BPassword.make((String)existing.toString()));
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(convertToPassword)) {
            String nonPasswordProps = Arrays.stream(this.getDynamicPropertiesArray()).filter(property -> !this.get((Property)property).getType().is(BPassword.TYPE)).map(property -> SlotPath.unescape((String)property.getName())).sorted().collect(Collectors.joining(","));
            return BString.make((String)nonPasswordProps);
        }
        return action.getParameterDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(HttpConsumable consumable) {
        if (consumable instanceof HttpCommResponse) {
            HttpCommResponse response = (HttpCommResponse)consumable;
            Map<String, String> map = this.captureValues;
            synchronized (map) {
                this.captureValues.clear();
                response.getHeaders().forEach((headerName, headerValues) -> {
                    if (this.acceptHeader((String)headerName)) {
                        this.processHeader((String)headerName, (List<String>)headerValues);
                    }
                });
                this.captureValues.forEach(this::captureHeader);
                PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, "Captured: " + this.captureValues, (Object)this);
            }
        }
    }

    protected boolean acceptHeader(String name) {
        return name != null;
    }

    protected void processHeader(String headerName, List<String> headerValues) {
        String slotName = SlotPath.escape((String)headerName);
        if (!slotName.isEmpty()) {
            String propertyName = this.findMatchingProperty(slotName, this.isCaseSensitive());
            propertyName = propertyName == null ? slotName : propertyName;
            this.captureValues.putIfAbsent(propertyName, "");
            String valueToSet = this.getSlotValue(propertyName, headerValues);
            this.captureValues.put(propertyName, valueToSet);
        }
    }

    protected boolean isCaseSensitive() {
        return false;
    }

    private String getSlotValue(String headerName, List<String> headerValues) {
        if (headerValues.isEmpty()) {
            return null;
        }
        if (this.getConcatDuplicates()) {
            String valueToSet = String.join((CharSequence)", ", headerValues);
            String existingValue = this.captureValues.get(headerName);
            if (!existingValue.isEmpty()) {
                valueToSet = String.join((CharSequence)", ", existingValue, valueToSet);
            }
            return valueToSet;
        }
        return headerValues.get(headerValues.size() - 1);
    }

    private void captureHeader(String propertyName, String value) {
        Property property = this.getProperty(propertyName);
        if (property == null && this.getCaptureAll()) {
            this.add(propertyName, (BValue)BString.make((String)value));
        } else if (property != null) {
            BPassword valueToSet = this.get(property) instanceof BPassword ? BPassword.make((String)value) : BString.make((String)value);
            this.set(property, (BValue)valueToSet);
        }
    }

    private String findMatchingProperty(String name, boolean caseSensitive) {
        for (Property property : this.getDynamicPropertiesArray()) {
            if (!BResponseHeaderCapture.namesMatch(property.getName(), name, caseSensitive)) continue;
            return property.getName();
        }
        for (String captureName : this.captureValues.keySet()) {
            if (!BResponseHeaderCapture.namesMatch(captureName, name, caseSensitive)) continue;
            return captureName;
        }
        return null;
    }

    private static boolean namesMatch(String a, String b, boolean caseSensitive) {
        return a.equals(b) || !caseSensitive && a.equalsIgnoreCase(b);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

