/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperty(name="lastSentTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=73729, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")})
@NiagaraAction(name="reset")
public abstract class BMetrics
extends BComponent {
    public static final int METRIC_FLAGS = 73729;
    public static final Property lastSentTime = BMetrics.newProperty((int)73729, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Action reset = BMetrics.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BMetrics.class);
    private static final RoundingMode AVG_ROUNDING_MODE = RoundingMode.HALF_UP;
    private final Object mutex = new Object();

    public BAbsTime getLastSentTime() {
        return (BAbsTime)this.get(lastSentTime);
    }

    public void setLastSentTime(BAbsTime v) {
        this.set(lastSentTime, (BValue)v, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReset() {
        Object object = this.mutex;
        synchronized (object) {
            Property[] props = this.getFrozenPropertiesArray();
            Arrays.stream(props).forEach(property -> this.set((Property)property, property.getDefaultValue()));
        }
    }

    protected static BFacets createMillisUnitFacet() {
        return BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"));
    }

    protected static BFacets createByteUnitFacet() {
        return BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"byte"));
    }

    protected static BFacets createPrecisionFacet(int precision) {
        return BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)precision));
    }

    protected void calculateAverage(Property avgMetric, Property sumProperty, Property dividerProperty) {
        BigDecimal avg = BigDecimal.valueOf(this.getLong(sumProperty)).setScale(2, AVG_ROUNDING_MODE).divide(BigDecimal.valueOf(this.getLong(dividerProperty)), AVG_ROUNDING_MODE);
        this.setDouble(avgMetric, avg.doubleValue());
    }

    protected void incrementMetric(Property property) {
        this.increaseMetric(property, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseMetric(Property property, long increase) {
        Object object = this.mutex;
        synchronized (object) {
            this.setLong(property, this.getLong(property) + increase);
        }
    }
}

