/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.driver.poll;

import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fastRate", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)")}, override=true), @NiagaraProperty(name="normalRate", type="BRelTime", defaultValue="BRelTime.makeMinutes(1)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)")}, override=true), @NiagaraProperty(name="slowRate", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)")}, override=true)})
public class BHttpClientPollScheduler
extends BNPollScheduler {
    public static final Property fastRate = BHttpClientPollScheduler.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property normalRate = BHttpClientPollScheduler.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property slowRate = BHttpClientPollScheduler.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Type TYPE = Sys.loadType(BHttpClientPollScheduler.class);

    public Type getType() {
        return TYPE;
    }

    public void doPoll(BIPollable p) {
        boolean denyPoll;
        try {
            BDeviceNetwork net = (BDeviceNetwork)this.getParent();
            denyPoll = net.isDisabled() || net.isDown() || net.isFault();
        }
        catch (Exception e) {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINEST, "Poll denied", (Throwable)e, (Object)this);
            denyPoll = true;
        }
        if (denyPoll) {
            return;
        }
        if (!(p instanceof BINPollable)) {
            throw new BajaRuntimeException(p.getClass().getName() + " must be a implement BINPollable");
        }
        BINPollable proxy = (BINPollable)p;
        try {
            proxy.doPoll();
        }
        catch (NotRunningException e) {
            this.unsubscribe((BIPollable)proxy);
        }
        catch (Exception e) {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.WARNING, "Polling Error", (Throwable)e, (Object)proxy);
            throw e;
        }
    }
}

