/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.driver;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import com.tridiumeurope.httpClient.BHttpClientService;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.comm.transport.BHttpTransport;
import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridiumeurope.httpClient.driver.BHttpClientNetwork;
import com.tridiumeurope.httpClient.driver.ping.BHttpClientPingAddress;
import com.tridiumeurope.httpClient.driver.point.BHttpClientPointDeviceExt;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.ParentLegal;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceFolder;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="authenticator", type="BHttpAuthenticator", defaultValue="new BHttpAuthenticator()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="transport", type="BHttpTransport", defaultValue="new BHttpTransport()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="pingAddress", type="BHttpClientPingAddress", defaultValue="new BHttpClientPingAddress()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}), @NiagaraProperty(name="points", type="BHttpClientPointDeviceExt", defaultValue="new BHttpClientPointDeviceExt()"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.DEFAULT", flags=65603, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="out", type="BString", defaultValue="BString.DEFAULT", flags=65547, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
@NiagaraAction(name="populateFromUrl", parameterType="BString", defaultValue="BString.DEFAULT")
public class BHttpClientDevice
extends BNDevice
implements BIHttpCommClientTransport {
    public static final Property authenticator = BHttpClientDevice.newProperty((int)0, (BValue)new BHttpAuthenticator(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property transport = BHttpClientDevice.newProperty((int)0, (BValue)new BHttpTransport(), (BFacets)SfUtil.incl((String)"ed"));
    public static final Property pingAddress = BHttpClientDevice.newProperty((int)0, (BValue)new BHttpClientPingAddress(), (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property points = BHttpClientDevice.newProperty((int)0, (BValue)new BHttpClientPointDeviceExt(), null);
    public static final Property status = BHttpClientDevice.newProperty((int)65603, (BValue)BStatus.DEFAULT, (BFacets)SfUtil.incl((String)"ed.ro"));
    public static final Property out = BHttpClientDevice.newProperty((int)65547, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Action populateFromUrl = BHttpClientDevice.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BHttpClientDevice.class);
    private final ExecutorService executorService = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)("PingComm:" + TYPE.getTypeName()), (long)6L, (TimeUnit)TimeUnit.MINUTES);

    @Override
    public BHttpAuthenticator getAuthenticator() {
        return (BHttpAuthenticator)this.get(authenticator);
    }

    @Override
    public void setAuthenticator(BHttpAuthenticator v) {
        this.set(authenticator, (BValue)v, null);
    }

    @Override
    public BHttpTransport getTransport() {
        return (BHttpTransport)this.get(transport);
    }

    @Override
    public void setTransport(BHttpTransport v) {
        this.set(transport, (BValue)v, null);
    }

    public BHttpClientPingAddress getPingAddress() {
        return (BHttpClientPingAddress)this.get(pingAddress);
    }

    public void setPingAddress(BHttpClientPingAddress v) {
        this.set(pingAddress, (BValue)v, null);
    }

    public BHttpClientPointDeviceExt getPoints() {
        return (BHttpClientPointDeviceExt)this.get(points);
    }

    public void setPoints(BHttpClientPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public String getOut() {
        return this.getString(out);
    }

    public void setOut(String v) {
        this.setString(out, v, null);
    }

    public void populateFromUrl(BString parameter) {
        this.invoke(populateFromUrl, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doPopulateFromUrl(BString urlString) {
        HttpClientUtils.populateFromUrl(this.getPingAddress().getAddress(), urlString.toString());
    }

    public final void doPing() {
        block6: {
            BHttpClientPingAddress pingAddress = this.getPingAddress();
            if (this.isRunning() && !this.isFatalFault() && this.getEnabled() && BHttpClientService.permittedByService((BIHttpCommClient)pingAddress, null)) {
                if (!pingAddress.getAddress().isConfigured()) {
                    this.pingOk();
                    return;
                }
                PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "device ping using " + pingAddress, (Object)pingAddress);
                try {
                    HttpCommResponse response = this.send(pingAddress, pingAddress);
                    this.setOut(response.getBody());
                    if (response.isGood()) {
                        this.pingOk();
                        break block6;
                    }
                    this.pingFail("Response Code: " + response.getResponseCode());
                }
                catch (Exception e) {
                    PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.WARNING, "Ping Error for " + this.getName(), (Throwable)e, (Object)pingAddress);
                    this.pingFail(e.getLocalizedMessage());
                }
            } else {
                this.pingFail("No ping attempted due to fault or enabled state");
            }
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BHttpClientNetwork.TYPE, BDeviceFolder.TYPE);
    }

    public Type getNetworkType() {
        return BHttpClientNetwork.TYPE;
    }

    public final BHttpClientNetwork getHttpNetwork() {
        return (BHttpClientNetwork)DrUtil.getParent((BComplex)this, (Type)BHttpClientNetwork.TYPE);
    }

    protected IFuture postPing() {
        this.executorService.execute((Runnable)new Invocation((BComponent)this, ping, null, Context.NULL));
        return null;
    }

    public void stopped() {
        ExecutorUtil.shutdown((ExecutorService)this.executorService);
    }

    public int getPointManagerSubscribeDepth() {
        return 3;
    }
}

