/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.payload;

import com.tridium.driver.util.DrUtil;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpPayloadResetPolicy;
import com.tridiumeurope.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridiumeurope.httpClient.datatypes.payload.BRequestBody;
import com.tridiumeurope.httpClient.util.BIHttpConsumer;
import com.tridiumeurope.httpClient.util.HttpConsumable;
import com.tridiumeurope.httpClient.ws.WsMessageEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="data", type="BString", defaultValue="BString.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE)")}), @NiagaraProperty(name="clearPayloadAfter", type="BHttpPayloadResetPolicy", defaultValue="BHttpPayloadResetPolicy.DEFAULT")})
public class BSlotSource
extends BAbstractPayloadSource
implements BIHttpConsumer {
    public static final Property data = BSlotSource.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property clearPayloadAfter = BSlotSource.newProperty((int)0, (BValue)BHttpPayloadResetPolicy.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BSlotSource.class);

    public String getData() {
        return this.getString(data);
    }

    public void setData(String v) {
        this.setString(data, v, null);
    }

    public BHttpPayloadResetPolicy getClearPayloadAfter() {
        return (BHttpPayloadResetPolicy)this.get(clearPayloadAfter);
    }

    public void setClearPayloadAfter(BHttpPayloadResetPolicy v) {
        this.set(clearPayloadAfter, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BSlotSource make(String data) {
        BSlotSource payloadConfig = new BSlotSource();
        payloadConfig.setData(data);
        return payloadConfig;
    }

    @Override
    public void consume(HttpConsumable consumable) {
        if (consumable instanceof HttpCommResponse) {
            this.clearData(((HttpCommResponse)consumable).isSuccessResponse());
        } else if (consumable instanceof WsMessageEvent) {
            this.clearData(((WsMessageEvent)consumable).isSuccess());
        }
    }

    private void clearData(boolean sendSuccess) {
        boolean onSuccess;
        boolean failure = this.getClearPayloadAfter() == BHttpPayloadResetPolicy.failure && !sendSuccess;
        boolean bl = onSuccess = this.getClearPayloadAfter() == BHttpPayloadResetPolicy.success && sendSuccess;
        if (failure || onSuccess || this.getClearPayloadAfter() == BHttpPayloadResetPolicy.both) {
            this.setData("");
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            boolean sendNewPayload;
            BRequestBody requestBody = (BRequestBody)this.getParent().as(BRequestBody.class);
            boolean bl = sendNewPayload = property.equals(data) && !this.getData().isEmpty() && requestBody.getSendOnSourceCov();
            if (sendNewPayload) {
                this.sendOnCov();
            }
        }
    }

    protected void sendOnCov() {
        BComplex parentWriter = DrUtil.getParent((BComplex)this, (Type)BIHttpCommClientWrite.TYPE);
        if (parentWriter instanceof BIHttpCommClientWrite) {
            AccessController.doPrivileged(() -> {
                ((BIHttpCommClientWrite)parentWriter).writeRequested();
                return null;
            });
        }
    }

    @Override
    public void prepareToSend() {
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.getData().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long length() {
        return this.getData().getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public String identifierForLogs() {
        return String.format("%1.20s", this.getData());
    }

    public BIcon getIcon() {
        return BIcon.std((String)"upload.png");
    }
}

