/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.options;

import com.tridium.driver.util.DrUtil;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.datatypes.enums.BOptionMergePolicy;
import com.tridiumeurope.httpClient.datatypes.options.BAddOptionDetail;
import com.tridiumeurope.httpClient.datatypes.options.BICalculatedOption;
import com.tridiumeurope.httpClient.datatypes.options.BIHttpOptionsSupplier;
import com.tridiumeurope.httpClient.datatypes.options.autoheaders.BAutoHeader;
import com.tridiumeurope.httpClient.driver.BHttpClientDeviceFolder;
import com.tridiumeurope.httpClient.driver.point.BHttpClientPointFolder;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.ParentLegal;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="inherit", type="BOptionMergePolicy", defaultValue="BOptionMergePolicy.DEFAULT")
@NiagaraActions(value={@NiagaraAction(name="add", parameterType="BAddOptionDetail", defaultValue="new BAddOptionDetail()"), @NiagaraAction(name="remove", parameterType="BString", defaultValue="BString.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"httpClient:PropertyPickerFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"httpClient:PropertyPicker\"")})})
public abstract class BAbstractHttpOptions
extends BComponent {
    public static final Property inherit = BAbstractHttpOptions.newProperty((int)0, (BValue)BOptionMergePolicy.DEFAULT, null);
    public static final Action add = BAbstractHttpOptions.newAction((int)0, (BValue)new BAddOptionDetail(), null);
    public static final Action remove = BAbstractHttpOptions.newAction((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"httpClient:PropertyPickerFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"httpClient:PropertyPicker")));
    public static final Type TYPE = Sys.loadType(BAbstractHttpOptions.class);
    private final ConcurrentHashMap<String, String> requestMap = new ConcurrentHashMap();
    private static final List<String> ignoredProperties = Arrays.asList("displayNames", "wsAnnotation");

    public BOptionMergePolicy getInherit() {
        return (BOptionMergePolicy)this.get(inherit);
    }

    public void setInherit(BOptionMergePolicy v) {
        this.set(inherit, (BValue)v, null);
    }

    public void add(BAddOptionDetail parameter) {
        this.invoke(add, (BValue)parameter, null);
    }

    public void remove(BString parameter) {
        this.invoke(remove, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.isRunning()) {
            Property[] headerProp = this.getDynamicPropertiesArray();
            Arrays.stream(headerProp).forEach(property -> this.addToRequest((Property)property));
        }
    }

    public void added(Property property, Context context) {
        if (this.isRunning()) {
            this.addToRequest(property);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            this.addToRequest(property);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning()) {
            this.requestMap.remove(this.unescape(property.getName()));
        }
    }

    public void addNewOption(String name, BValue value) {
        Property added = this.add(SlotPath.escape((String)name), value);
        if (!this.isRunning()) {
            this.addToRequest(added);
        }
    }

    public void addToRequest(String name, String value) {
        if (value != null) {
            this.requestMap.put(this.unescape(name), value);
        } else {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Ignoring null value for field " + name, (Object)this);
        }
    }

    public BAbstractHttpOptions prepareForSend() {
        BAbstractHttpOptions merged = this.prepare().merge();
        if (HttpClientUtils.MAIN_LOGGER.isLoggable(Level.FINE)) {
            merged.asMap().forEach((k, v) -> PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> String.format("outgoing user defined option: [%s]:[%s]", k, v), (Object)this));
        }
        return merged;
    }

    private BAbstractHttpOptions prepare() {
        this.requestMap.clear();
        Arrays.stream(this.getPropertiesArray()).forEach(property -> {
            BValue option = this.get((Property)property);
            if (option.getType().is(BICalculatedOption.TYPE)) {
                String val = ((BICalculatedOption)option.as(BICalculatedOption.class)).calculate();
                if (val != null) {
                    this.addToRequest((Property)property);
                }
            } else {
                this.addToRequest((Property)property);
            }
        });
        return this;
    }

    private BAbstractHttpOptions merge() {
        BIHttpOptionsSupplier papa;
        if (this.getInherit().equals((Object)BOptionMergePolicy.inherit) && (papa = (BIHttpOptionsSupplier)DrUtil.getParent((BComplex)this, (Type)BIHttpOptionsSupplier.TYPE)) != null && papa.asObject().isComponent()) {
            BAbstractHttpOptions[] papaOptions = (BAbstractHttpOptions[])papa.asObject().asComponent().getChildren(BAbstractHttpOptions.class);
            Arrays.stream(papaOptions).forEach(options -> {
                if (options.getType().equals(this.getType())) {
                    options.prepare();
                    options.asMap().forEach(this.requestMap::putIfAbsent);
                }
            });
        }
        return this;
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.requestMap);
    }

    private void addToRequest(Property property) {
        if (property == inherit || property == null || BAbstractHttpOptions.ignoreProperty(property)) {
            return;
        }
        BValue value = this.get(property);
        if (BAbstractHttpOptions.ignoreType(value)) {
            return;
        }
        if (value != null) {
            this.addToRequest(this.unescape(property.getName()), value.toString(Context.NULL));
        } else {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, "Ignoring null value for property " + property.getName(), (Object)this);
        }
    }

    private static boolean ignoreProperty(Property property) {
        return ignoredProperties.contains(property.getName());
    }

    private static boolean ignoreType(BValue value) {
        return value.getType().is(BComplex.TYPE) && !value.getType().is(BAutoHeader.TYPE);
    }

    boolean contains(String name) {
        return this.requestMap.containsKey(this.unescape(name));
    }

    String unescape(String name) {
        return SlotPath.unescape((String)name);
    }

    public void doAdd(BAddOptionDetail detail) {
        PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Adding " + detail.getSlotName() + ' ' + (Object)((Object)detail.getSlotType()), (Object)this);
        this.add(SlotPath.escape((String)detail.getSlotName()), (BValue)detail.getSlotDefaultValue());
    }

    public void doRemove(BString slotName) {
        if (slotName.equals((Object)BString.DEFAULT) || slotName.getString().contains(",")) {
            return;
        }
        String slot = SlotPath.escape((String)slotName.getString());
        Property existingSlot = this.getProperty(slot);
        if (existingSlot != null) {
            this.remove(existingSlot);
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(remove)) {
            String deletableSlots = Arrays.stream(this.getDynamicPropertiesArray()).map(property -> SlotPath.unescape((String)property.getName())).sorted().collect(Collectors.joining(","));
            return BString.make((String)deletableSlots);
        }
        return action.getParameterDefault();
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BIHttpCommClient.TYPE, BHttpClientPointFolder.TYPE, BHttpClientDeviceFolder.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"newFolder.png");
    }
}

