/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.auth;

import com.tridiumeurope.httpClient.util.HttpClientUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;

public class HttpDigestHelper {
    private String serverNonce;
    private final Random random = new Random();
    private final AtomicInteger nc = new AtomicInteger();
    private final String realm;
    private final String method;
    private final String hostAddress;
    private final String uriPath;
    private final Integer port;
    private final Optional<String> opaque;
    private final Optional<String> qop;
    private final Optional<String> algorithm;
    public static final String DIGEST_SCHEME = "Digest";
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final String SESS_SUFFIX = "-sess";
    public static final String AUTH_QOP = "auth";
    public static final String AUTH_INT_QOP = "auth-int";
    public static final String NEXT_NONCE = "nextnonce";

    public HttpDigestHelper(String serverChallenge, String hostAddress, Integer port, String uriPath, String method) {
        this.realm = HttpDigestHelper.unquote(HttpClientUtils.readTokenFromAuthHeader(serverChallenge, "realm", false));
        this.serverNonce = HttpDigestHelper.unquote(HttpClientUtils.readTokenFromAuthHeader(serverChallenge, "nonce", false));
        this.opaque = HttpDigestHelper.unquote(HttpClientUtils.readOptionalTokenFromAuthHeader(serverChallenge, "opaque", false));
        this.qop = HttpDigestHelper.unquote(HttpClientUtils.readOptionalTokenFromAuthHeader(serverChallenge, "qop", false));
        this.algorithm = HttpClientUtils.readOptionalTokenFromAuthHeader(serverChallenge, "algorithm", false);
        this.method = method;
        this.hostAddress = hostAddress;
        this.uriPath = uriPath;
        this.port = port;
        if (!this.readyToBuildAuthHeader()) {
            throw new IllegalStateException("Minimum requirement for digest header not met");
        }
    }

    public void update(String authInfo) {
        Optional<String> nextNonce = HttpClientUtils.readOptionalTokenFromAuthHeader("Digest " + authInfo, NEXT_NONCE, false);
        nextNonce.ifPresent(nn -> {
            this.serverNonce = nn;
        });
    }

    public boolean readyToBuildAuthHeader() {
        return this.realm != null && this.serverNonce != null && this.uriPath != null && this.port != null && this.method != null;
    }

    public String createAuthString(BUsernameAndPassword credentials) throws Exception {
        String nc = this.getNextCounterHexString();
        String cnonce = this.createRandomClientNonce(nc);
        StringBuilder authHeaderValue = new StringBuilder(DIGEST_SCHEME).append(' ').append("username=\"").append(credentials.getUsername()).append("\", ").append("realm=\"").append(this.realm).append("\", ").append("nonce=\"").append(this.serverNonce).append("\", ").append("uri=\"").append(this.uriPath).append("\", ");
        this.algorithm.ifPresent(s -> authHeaderValue.append("algorithm=\"").append((String)s).append("\", "));
        this.qop.ifPresent(s -> authHeaderValue.append("qop=").append((String)s).append(", ").append("nc=").append(nc).append(", ").append("cnonce=\"").append(cnonce).append("\", "));
        String response = this.createResponse(credentials, cnonce, nc);
        authHeaderValue.append("response=\"").append(response).append('\"');
        this.opaque.ifPresent(s -> authHeaderValue.append(", opaque=\"").append((String)s).append('\"'));
        return authHeaderValue.toString();
    }

    private String createResponse(BUsernameAndPassword credentials, String cnonce, String nc) throws Exception {
        String password = credentials.getPassword().getValue();
        String ha1 = this.hash(String.format("%s:%s:%s", credentials.getUsername(), this.realm, password));
        if (this.algorithm.isPresent() && this.algorithm.get().endsWith(SESS_SUFFIX)) {
            ha1 = this.hash(String.format("%s:%s:%s", ha1, this.serverNonce, cnonce));
        }
        String ha2 = this.hash(String.format("%s:%s", this.method, this.uriPath));
        if (this.qop.isPresent() && this.qop.get().equals(AUTH_INT_QOP)) {
            throw new BajaRuntimeException("auth-int not currently supported");
        }
        if (this.qop.isPresent() && this.qop.get().equals(AUTH_QOP)) {
            return this.hash(String.format("%s:%s:%s:%s:%s:%s", ha1, this.serverNonce, nc, cnonce, this.qop.get(), ha2));
        }
        return this.hash(String.format("%s:%s:%s", ha1, this.serverNonce, ha2));
    }

    public String createRandomClientNonce(String nc) throws Exception {
        return this.hash("cnonce" + nc + this.hostAddress + this.port + System.currentTimeMillis() + this.random.nextInt());
    }

    private String hash(String in) throws Exception {
        String alg = this.algorithm.orElse(DEFAULT_ALGORITHM);
        if (alg.toLowerCase().endsWith(SESS_SUFFIX)) {
            alg = alg.substring(0, alg.indexOf(45));
        }
        byte[] bytes = MessageDigest.getInstance(alg).digest(in.getBytes(StandardCharsets.UTF_8));
        return TextUtil.bytesToHexString((byte[])bytes);
    }

    private String getNextCounterHexString() {
        String clientNonce = "00000000" + Integer.toHexString(this.nc.incrementAndGet());
        return clientNonce.substring(clientNonce.length() - 8);
    }

    private static Optional<String> unquote(Optional<String> s) {
        return s.map(HttpDigestHelper::unquote);
    }

    private static String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }
}

