/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.auth;

import com.tridiumeurope.httpClient.util.CaseInsensitiveStrKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.web.authn.AuthMessage;

public class HttpClientAuthMessage
extends AuthMessage {
    public static final String ILLEGAL_TOKEN_CHARS = "(),/:;<=>?@[\\]{}";
    private String scheme;
    private final Map<CaseInsensitiveStrKey, String> parameters = new LinkedHashMap<CaseInsensitiveStrKey, String>();

    public static HttpClientAuthMessage decodeMessageFromString(String message) {
        HttpClientAuthMessage auth = new HttpClientAuthMessage();
        int space = message.indexOf(32);
        if (space >= 0) {
            auth.setScheme(message.substring(0, space));
            String params = message.substring(space + 1);
            StringTokenizer tokenizer = new StringTokenizer(params, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                int equal = token.indexOf(61);
                if (equal <= -1) {
                    throw new IllegalArgumentException("parameter missing '='");
                }
                String key = token.substring(0, equal).trim();
                String value = token.substring(equal + 1).trim();
                if (auth.getParameter(key) != null) {
                    throw new IllegalArgumentException("duplicate parameter");
                }
                auth.setParameter(key, value);
            }
        } else {
            auth.setScheme(message);
        }
        return auth;
    }

    public void setParameter(String key, String value) {
        if (!HttpClientAuthMessage.isValidMessageToken(key)) {
            throw new IllegalArgumentException("Parameter key is not a valid token");
        }
        if (!HttpClientAuthMessage.isValidMessageToken(value)) {
            throw new IllegalArgumentException("Parameter value is not a valid token");
        }
        this.parameters.put(new CaseInsensitiveStrKey(key), value);
    }

    public String getParameter(String key) {
        return this.parameters.get(new CaseInsensitiveStrKey(key));
    }

    public void setScheme(String scheme) {
        if (!HttpClientAuthMessage.isValidMessageToken(scheme)) {
            throw new IllegalArgumentException("Method is not a valid token");
        }
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    protected static boolean isValidMessageToken(String token) {
        boolean inQuotes = false;
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c == '\'' || c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c >= '!' && c <= '\u007f' && (inQuotes || ILLEGAL_TOKEN_CHARS.indexOf(c) <= -1)) continue;
            return false;
        }
        return true;
    }
}

