/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.auth;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridiumeurope.httpClient.datatypes.auth.HttpDigestHelper;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.HttpConsumable;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="credentials", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=64)
@NiagaraAction(name="clearSession")
public class BHttpDigestAuth
extends BAuthorizationHeaderScheme {
    public static final Property credentials = BHttpDigestAuth.newProperty((int)64, (BValue)new BUsernameAndPassword(), null);
    public static final Action clearSession = BHttpDigestAuth.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BHttpDigestAuth.class);
    private final Object mutex = new Object();
    private HttpDigestHelper digestHelper;
    private BHttpAddress address;
    private String method;

    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    public void clearSession() {
        this.invoke(clearSession, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClearSession() {
        Object object = this.mutex;
        synchronized (object) {
            this.digestHelper = null;
        }
    }

    @Override
    public void consume(HttpConsumable consumable) {
        super.consume(consumable);
        if (consumable instanceof HttpCommResponse && ((HttpCommResponse)consumable).isGood()) {
            Optional<String> authInfo = ((HttpCommResponse)consumable).getHeaders().getHeader("Authentication-Info");
            authInfo.ifPresent(s -> this.digestHelper.update((String)s));
        } else {
            this.doClearSession();
        }
    }

    @Override
    public String getAuthHeaderValue(BIHttpCommClient client) {
        if (this.digestHelper == null) {
            try {
                this.digestInitialRequest(client);
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.SEVERE, "Digest initial request failed", (Throwable)e, (Object)this);
                return null;
            }
        }
        try {
            return this.digestHelper.createAuthString(this.getCredentials());
        }
        catch (Exception e) {
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.SEVERE, "Digest auth failed to create auth header", (Throwable)e, (Object)this);
            return null;
        }
    }

    public void digestInitialRequest(BIHttpCommClient client) throws Exception {
        String challenge = this.getInitialRequestChallenge(client);
        this.digestHelper = new HttpDigestHelper(challenge, this.address.getHostAddress(), this.address.getPort(), this.address.getPath(), this.method);
    }

    private String getInitialRequestChallenge(BIHttpCommClient client) throws Exception {
        HttpCommResponse response = this.sendInitialRequest(client);
        Optional<String> headerVal = response.getHeaders().getHeader("WWW-Authenticate");
        return headerVal.orElseThrow(() -> new BajaRuntimeException("Missing header: WWW-Authenticate"));
    }

    protected HttpCommResponse sendInitialRequest(BIHttpCommClient client) throws Exception {
        this.address = (BHttpAddress)client.getAddress().newCopy().as(BHttpAddress.class);
        this.method = client.getMethod().getTag().toUpperCase();
        PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, "Sending Initial Digest Request", (Object)this);
        HttpCommResponse response = this.sendAuthRequest(client, this.address, new BHttpHeaders());
        PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> "Digest Auth Response: " + response.getResponseCode(), (Object)this);
        return response;
    }

    public static BHttpAuthenticator createHttpDigestAuthenticator(String username, String password) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(TYPE.getTypeSpec());
        authenticator.checkAuthenticator();
        BHttpDigestAuth auth = (BHttpDigestAuth)authenticator.getConfig().as(BHttpDigestAuth.class);
        auth.setCredentials(new BUsernameAndPassword(username, password));
        return authenticator;
    }
}

