/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.auth;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridiumeurope.httpClient.datatypes.auth.BHttpAuthenticator;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="usernameAndPassword", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()")
public class BBasicHttpAuth
extends BAuthorizationHeaderScheme {
    public static final Property usernameAndPassword = BBasicHttpAuth.newProperty((int)0, (BValue)new BUsernameAndPassword(), null);
    public static final Type TYPE = Sys.loadType(BBasicHttpAuth.class);

    public BUsernameAndPassword getUsernameAndPassword() {
        return (BUsernameAndPassword)this.get(usernameAndPassword);
    }

    public void setUsernameAndPassword(BUsernameAndPassword v) {
        this.set(usernameAndPassword, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getAuthHeaderValue(BIHttpCommClient client) {
        String username = this.getUsernameAndPassword().getUsername();
        byte[] b = (username + ':' + this.getUsernameAndPassword().getPassword().getValue()).getBytes(StandardCharsets.UTF_8);
        return "Basic " + Base64.getEncoder().encodeToString(b);
    }

    public static BHttpAuthenticator createBasicAuthenticator(String username, String password) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(TYPE.getTypeSpec());
        authenticator.checkAuthenticator();
        BBasicHttpAuth basic = (BBasicHttpAuth)authenticator.getConfig().as(BBasicHttpAuth.class);
        basic.setUsernameAndPassword(new BUsernameAndPassword(username, BPassword.make((String)password)));
        return authenticator;
    }
}

