/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.datatypes.auth;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.comm.transport.HttpRequestInstance;
import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridiumeurope.httpClient.datatypes.auth.BNoHttpAuth;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpRequestMethod;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.datatypes.options.BHttpParameters;
import com.tridiumeurope.httpClient.datatypes.payload.BRequestBody;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BAuthorizationHeaderScheme
extends BAbstractHttpAuth {
    public static final Type TYPE = Sys.loadType(BAuthorizationHeaderScheme.class);
    public static final String AUTH_HEADER_NAME = "Authorization";

    @Override
    public Type getType() {
        return TYPE;
    }

    public abstract String getAuthHeaderValue(BIHttpCommClient var1);

    protected HttpCommResponse sendAuthRequest(BIHttpCommClient client, BHttpAddress authAddress, BHttpHeaders authHeaders) throws HttpCommException {
        BIHttpCommClientTransport transport = HttpClientUtils.getParent((BComplex)this, BIHttpCommClientTransport.class);
        if (transport != null) {
            return BAuthorizationHeaderScheme.sendAuthRequest(client, transport, authAddress, authHeaders);
        }
        throw new HttpCommException("No transport found for client: " + ((BComplex)client.as(BComplex.class)).getName());
    }

    private static HttpCommResponse sendAuthRequest(BIHttpCommClient client, BIHttpCommClientTransport transport, BHttpAddress address, BHttpHeaders headers) throws HttpCommException {
        Object requestInstance = transport.getTransport().getComm().createNewRequest(client);
        ((HttpRequestInstance)requestInstance).applyAddress(address).applyHeaders(headers).applyAuthenticator(new BNoHttpAuth()).applyData(BHttpRequestMethod.get, new BHttpParameters(), new BRequestBody());
        return transport.getTransport().getComm().send(client, requestInstance, new BNoHttpAuth());
    }
}

