/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.conditions;

import com.tridiumeurope.httpClient.conditions.BAbstractCondition;
import com.tridiumeurope.httpClient.datatypes.IHttpMessage;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fromTime", type="BTime", defaultValue="BTime.DEFAULT"), @NiagaraProperty(name="toTime", type="BTime", defaultValue="BTime.DEFAULT")})
public class BTimeIsBetween
extends BAbstractCondition {
    public static final Property fromTime = BTimeIsBetween.newProperty((int)0, (BValue)BTime.DEFAULT, null);
    public static final Property toTime = BTimeIsBetween.newProperty((int)0, (BValue)BTime.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BTimeIsBetween.class);
    private static final BIcon TIME_ICON = BIcon.make((BIcon)BIcon.std((String)"control/logic/equal.png"), (BIcon)BIcon.make((String)"module://icons/x16/badges/clock.png"));

    public BTime getFromTime() {
        return (BTime)this.get(fromTime);
    }

    public void setFromTime(BTime v) {
        this.set(fromTime, (BValue)v, null);
    }

    public BTime getToTime() {
        return (BTime)this.get(toTime);
    }

    public void setToTime(BTime v) {
        this.set(toTime, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean test(IHttpMessage message) {
        BTime nowTime = BAbsTime.now().getTime();
        return nowTime.isAfter(this.getFromTime()) && nowTime.isBefore(this.getToTime());
    }

    @Override
    public BIcon getIcon() {
        return TIME_ICON;
    }
}

