/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.comm.transport.okHttp;

import com.tridium.crypto.core.cert.NoOpHostnameVerifier;
import com.tridiumeurope.httpClient.BHttpClientService;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.comm.client.ResponseHeaders;
import com.tridiumeurope.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridiumeurope.httpClient.comm.transport.okHttp.BOkHttpConnectionsSpec;
import com.tridiumeurope.httpClient.comm.transport.okHttp.OkHttpRequest;
import com.tridiumeurope.httpClient.datatypes.BHttpTuningPolicy;
import com.tridiumeurope.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridiumeurope.httpClient.datatypes.exception.HttpClientException;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="http2Enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="tlsConnectionSpec", type="BOkHttpConnectionsSpec", defaultValue="BOkHttpConnectionsSpec.DEFAULT", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")})})
public class BOkHttpTransport
extends BAbstractHttpTransport<OkHttpRequest> {
    public static final Property http2Enabled = BOkHttpTransport.newProperty((int)0, (boolean)false, null);
    public static final Property tlsConnectionSpec = BOkHttpTransport.newProperty((int)0, (BValue)BOkHttpConnectionsSpec.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BOkHttpTransport.class);
    private OkHttpClient okHttpClient;
    private static final Object MUTEX = new Object();
    private static final List<Protocol> ALL_PROTOCOLS = Arrays.asList(Protocol.HTTP_1_1, Protocol.HTTP_2);
    private static final List<Protocol> LEGACY_PROTOCOLS = Collections.singletonList(Protocol.HTTP_1_1);

    public boolean getHttp2Enabled() {
        return this.getBoolean(http2Enabled);
    }

    public void setHttp2Enabled(boolean v) {
        this.setBoolean(http2Enabled, v, null);
    }

    public BOkHttpConnectionsSpec getTlsConnectionSpec() {
        return (BOkHttpConnectionsSpec)this.get(tlsConnectionSpec);
    }

    public void setTlsConnectionSpec(BOkHttpConnectionsSpec v) {
        this.set(tlsConnectionSpec, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (Sys.isStation()) {
            this.initClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        Object object = MUTEX;
        synchronized (object) {
            if (this.okHttpClient != null) {
                this.okHttpClient.dispatcher().executorService().shutdown();
            }
        }
    }

    @Override
    public OkHttpRequest createNewRequest(BIHttpCommClient client) {
        return new OkHttpRequest(client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HttpCommResponse sendInternal(BIHttpCommClient client, OkHttpRequest requestInstance, BAbstractHttpAuth authenticator) {
        try {
            Request request = requestInstance.getRequest();
            BHttpTuningPolicy tuningPolicy = client.getHttpTuningPolicy();
            if (this.okHttpClient == null) {
                throw new HttpCommException("Internal error - no okHttpClient instance found");
            }
            OkHttpClient.Builder builder = this.okHttpClient.newBuilder().connectTimeout(tuningPolicy.getConnectTimeout().getMillis(), TimeUnit.MILLISECONDS).readTimeout(tuningPolicy.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS).followRedirects(tuningPolicy.getFollowRedirects()).retryOnConnectionFailure(tuningPolicy.getRetryOnConnectionFailure());
            Authenticator okHttpAuthenticator = BOkHttpTransport.getOkHttpAuthenticator(authenticator);
            if (okHttpAuthenticator != null) {
                builder.authenticator(okHttpAuthenticator);
            }
            OkHttpClient requestSpecificClient = builder.protocols(this.getHttp2Enabled() ? ALL_PROTOCOLS : LEGACY_PROTOCOLS).connectionSpecs(this.getConnectionSpecs()).build();
            BOkHttpTransport.printReqDebug(request, client);
            try (Response response = requestSpecificClient.newCall(request).execute();){
                String body = response.body() != null ? response.body().string() : "";
                ResponseHeaders headersMap = new ResponseHeaders(response.headers().toMultimap());
                HttpCommResponse httpCommResponse = HttpCommResponse.isSuccessResponse(response.code()) ? HttpCommResponse.makeGood(body, response.code(), headersMap) : HttpCommResponse.makeFailed(body, response.code(), headersMap, response.message(), null);
                return httpCommResponse;
            }
        }
        catch (HttpClientException | HttpCommException | IOException ioe) {
            return HttpCommResponse.makeFailed((Exception)ioe);
        }
    }

    public static void printReqDebug(Request request, BIHttpCommClient client) {
        if (TRANSPORT_LOG.isLoggable(Level.FINEST)) {
            try {
                StringBuilder debug = new StringBuilder().append("Configured OkHttp Request: [").append('\n').append(request.url()).append('\n').append(request.method()).append('\n').append(HttpClientUtils.safeHeadersForLogging(request.headers().toMultimap())).append(']');
                PrefixLogUtil.logWithPrefix(TRANSPORT_LOG, Level.FINEST, debug.toString(), (Object)client);
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix(TRANSPORT_LOG, Level.WARNING, "Could not build conn debug string", (Throwable)e, (Object)client);
            }
        }
    }

    public boolean isCompatibleTls() {
        return this.getTlsConnectionSpec().getOrdinal() >= 2;
    }

    private void initClient() {
        AccessController.doPrivileged(() -> {
            try {
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                try {
                    clientBuilder.sslSocketFactory(BOkHttpTransport.getSocketFactory(), HttpClientUtils.getTrustManager()).hostnameVerifier((HostnameVerifier)new NoOpHostnameVerifier());
                }
                catch (IOException e) {
                    PrefixLogUtil.logWithPrefix(TRANSPORT_LOG, Level.SEVERE, "Failed to initialize socket factory for okhttp transport - https connections may fail: ", (Throwable)e, (Object)this);
                }
                this.okHttpClient = clientBuilder.build();
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix(TRANSPORT_LOG, Level.WARNING, "Starting okHttp", (Throwable)e, (Object)this);
            }
            return null;
        });
    }

    private List<ConnectionSpec> getConnectionSpecs() throws HttpClientException {
        ArrayList<ConnectionSpec> connectionSpecs = new ArrayList<ConnectionSpec>();
        connectionSpecs.add(ConnectionSpec.RESTRICTED_TLS);
        if (this.getTlsConnectionSpec().getOrdinal() >= 1) {
            connectionSpecs.add(ConnectionSpec.MODERN_TLS);
        }
        if (this.getTlsConnectionSpec().getOrdinal() >= 2) {
            connectionSpecs.add(ConnectionSpec.COMPATIBLE_TLS);
        }
        if (BHttpClientService.service().getEnableInsecureHttp()) {
            connectionSpecs.add(ConnectionSpec.CLEARTEXT);
        }
        return connectionSpecs;
    }

    private static SSLSocketFactory getSocketFactory() throws IOException {
        try {
            ICryptoManager cryptoService = (ICryptoManager)Sys.getService((Type)Sys.getType((String)"platCrypto:CertManagerService"));
            return (SSLSocketFactory)cryptoService.getClientSocketFactory(ClientTlsParameters.DEFAULT);
        }
        catch (Exception e) {
            throw new IOException("Unable to get cryptoService instance: " + e.getMessage());
        }
    }

    private static Authenticator getOkHttpAuthenticator(BAbstractHttpAuth authenticator) {
        return null;
    }
}

