/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.comm.transport;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridiumeurope.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.BHttpTuningPolicy;
import com.tridiumeurope.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridiumeurope.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridiumeurope.httpClient.datatypes.auth.BTokenAuthScheme;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpMode;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpRequestMethod;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.datatypes.options.BHttpParameters;
import com.tridiumeurope.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridiumeurope.httpClient.datatypes.payload.BRequestBody;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.HttpConsumable;
import com.tridiumeurope.httpClient.util.IPrefixLoggable;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;

public abstract class HttpRequestInstance
implements IPrefixLoggable,
HttpConsumable {
    private final BIHttpCommClient client;

    protected HttpRequestInstance(BIHttpCommClient client) {
        this.client = client;
    }

    public abstract HttpRequestInstance applyAddress(BHttpAddress var1) throws HttpCommException;

    public abstract HttpRequestInstance applyHeaders(BHttpHeaders var1) throws HttpCommException;

    public abstract HttpRequestInstance applyAuthenticator(BAbstractHttpAuth var1) throws HttpCommException;

    public abstract HttpRequestInstance applyTuningPolicy(BHttpTuningPolicy var1) throws HttpCommException;

    public abstract HttpRequestInstance applyData(BHttpRequestMethod var1, BHttpParameters var2, BRequestBody var3) throws HttpCommException;

    public final HttpRequestInstance apply(BIHttpCommClientTransport transport, BIHttpCommClientWrite write) throws HttpCommException, PrivilegedActionException {
        BHttpParameters params = (BHttpParameters)this.client.getParameters().prepareForSend().as(BHttpParameters.class);
        BAbstractHttpAuth authenticator = transport.getAuthenticator().getConfig();
        BHttpHeaders preparedHeaders = (BHttpHeaders)this.client.getHeaders().prepareForSend().as(BHttpHeaders.class);
        AccessController.doPrivileged(() -> {
            authenticator.appendParameters(params);
            authenticator.appendHeaders(preparedHeaders);
            return null;
        });
        return this.verify(this.client, transport).applyAddress(this.client.getAddress()).applyHeaders(preparedHeaders).applyAuthenticator(authenticator).applyTuningPolicy(this.client.getHttpTuningPolicy()).applyData(this.client.getMethod(), params, this.initPayload(write));
    }

    public BRequestBody initPayload(BIHttpCommClientWrite write) {
        if (write != null) {
            BRequestBody requestBody = write.getRequestBody();
            BAbstractPayloadSource source2 = requestBody.getSource();
            source2.prepareToSend();
            requestBody.getContentTypeHeader().calculate();
            PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.FINE, () -> String.format("payload: [%s]", source2.identifierForLogs()), (Object)write);
            return requestBody;
        }
        return null;
    }

    public HttpRequestInstance verify(BIHttpCommClient client, BIHttpCommClientTransport transport) throws HttpCommException {
        BAbstractHttpAuth authenticator = transport.getAuthenticator().getConfig();
        if (client.getAddress().getMode() == BHttpMode.insecure && (authenticator instanceof BAuthorizationHeaderScheme || authenticator instanceof BTokenAuthScheme)) {
            throw new HttpCommException(transport.getAuthenticator().getConfig().getType().getTypeName() + " requires HTTPS");
        }
        return this;
    }

    public BIHttpCommClient getClient() {
        return this.client;
    }
}

