/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.comm.transport;

import com.tridiumeurope.httpClient.comm.client.BIHttpCommClient;
import com.tridiumeurope.httpClient.comm.client.HttpCommResponse;
import com.tridiumeurope.httpClient.comm.transport.HttpRequestInstance;
import com.tridiumeurope.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridiumeurope.httpClient.datatypes.exception.HttpCommException;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.ParentLegal;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BAbstractHttpTransport<T extends HttpRequestInstance>
extends BComponent {
    public static final Type TYPE = Sys.loadType(BAbstractHttpTransport.class);
    public static final Logger TRANSPORT_LOG = HttpClientUtils.child("transport");

    public Type getType() {
        return TYPE;
    }

    public abstract T createNewRequest(BIHttpCommClient var1);

    public final HttpCommResponse send(BIHttpCommClient client, T request, BAbstractHttpAuth authenticator) throws HttpCommException {
        BObject clientObj = client.asObject();
        if (this.isRunning() && clientObj.isComponent() && clientObj.asComponent().isRunning()) {
            if (client.equals(((HttpRequestInstance)request).getClient())) {
                return this.sendInternal(client, request, authenticator);
            }
            throw new HttpCommException("request/client mismatch");
        }
        throw new HttpCommException("send invoked on non mounted transport");
    }

    protected abstract HttpCommResponse sendInternal(BIHttpCommClient var1, T var2, BAbstractHttpAuth var3) throws HttpCommException;

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BIHttpCommClient.TYPE);
    }
}

