/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.comm.client;

import com.tridiumeurope.httpClient.util.CaseInsensitiveStrKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;

public class ResponseHeaders {
    public static final ResponseHeaders EMPTY = new ResponseHeaders(Collections.emptyMap());
    private final Map<CaseInsensitiveStrKey, List<String>> headers = new HashMap<CaseInsensitiveStrKey, List<String>>();

    public ResponseHeaders(Map<String, List<String>> headerValues) {
        headerValues.forEach((? super K headerName, ? super V values2) -> {
            if (headerName != null) {
                CaseInsensitiveStrKey key = new CaseInsensitiveStrKey((String)headerName);
                this.headers.putIfAbsent(key, new ArrayList());
                if (values2 != null) {
                    this.headers.get(key).addAll((Collection<String>)values2);
                }
            }
        });
    }

    public void forEach(BiConsumer<String, List<String>> consumer) {
        this.headers.forEach((? super K keyWrapper, ? super V value) -> consumer.accept(keyWrapper.getKey(), (List<String>)value));
    }

    public Optional<String> getHeader(String headerName) {
        List<String> headerVals = this.headers.get(new CaseInsensitiveStrKey(headerName));
        return headerVals != null && !headerVals.isEmpty() ? Optional.of(headerVals.get(0)) : Optional.empty();
    }

    public Optional<List<String>> getAllValues(String headerName) {
        List<String> headerVals = this.headers.get(new CaseInsensitiveStrKey(headerName));
        return headerVals != null ? Optional.of(headerVals) : Optional.empty();
    }
}

