/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.comm.client;

import com.tridiumeurope.httpClient.datatypes.BHttpAddress;
import com.tridiumeurope.httpClient.datatypes.BHttpResponseHealth;
import com.tridiumeurope.httpClient.datatypes.BHttpTuningPolicy;
import com.tridiumeurope.httpClient.datatypes.IHttpClient;
import com.tridiumeurope.httpClient.datatypes.IHttpResponse;
import com.tridiumeurope.httpClient.datatypes.enums.BHttpRequestMethod;
import com.tridiumeurope.httpClient.datatypes.options.BHttpHeaders;
import com.tridiumeurope.httpClient.datatypes.options.BHttpParameters;
import com.tridiumeurope.httpClient.util.HttpClientUtils;
import com.tridiumeurope.httpClient.util.IPrefixLoggable;
import com.tridiumeurope.httpClient.util.ModuleThreadPool;
import com.tridiumeurope.httpClient.util.PrefixLogUtil;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BIHttpCommClient
extends IHttpClient,
BInterface,
IPrefixLoggable {
    public static final Type TYPE = Sys.loadType(BIHttpCommClient.class);

    public BHttpResponseHealth getHealth();

    public void setHealth(BHttpResponseHealth var1);

    public BHttpRequestMethod getMethod();

    public void setMethod(BHttpRequestMethod var1);

    public BHttpAddress getAddress();

    public void setAddress(BHttpAddress var1);

    public BHttpHeaders getHeaders();

    public void setHeaders(BHttpHeaders var1);

    public BHttpParameters getParameters();

    public void setParameters(BHttpParameters var1);

    public BHttpTuningPolicy getHttpTuningPolicy();

    public boolean isDriverBasedClient();

    @Override
    default public Future<IHttpResponse> sendAsync() {
        return ModuleThreadPool.getInstance().submit(() -> {
            try {
                this.sendSync();
                return this.getHealth().getLastCommResponse();
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix(HttpClientUtils.MAIN_LOGGER, Level.SEVERE, "Async send request failed", (Throwable)e, (Object)this);
                return null;
            }
        });
    }

    @Override
    default public Optional<IHttpResponse> getLastResult() {
        return Optional.ofNullable(this.getHealth().getLastCommResponse());
    }

    @Override
    default public boolean hasResponse() {
        return this.getLastResponseCode() != -1;
    }

    @Override
    default public String getLastResponseBody() {
        return this.getLastResult().map(result -> result.getBody()).orElse(null);
    }

    @Override
    default public int getLastResponseCode() {
        return this.getLastResult().map(result -> result.getResponseCode()).orElse(-1);
    }
}

