/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.upgrade;

import com.tridium.driver.upgrade.Upgrade;
import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.BAxisVideoNetwork;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.naxisVideo.util.BAxisUserNameAndPassword;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.nvideo.upgrade.NVideoUpgrade;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;

public class AxisUpgrade
extends Upgrade {
    public String[] upgradableClasses() {
        return new String[]{"axisVideo:AxisVideoCamera", "axisVideo:AxisVideoDeviceFolder", "axisVideo:AxisVideoNetwork", "axisVideo:AxisVideoEventsReceiver", "axisVideo:AxisVideoPanTiltZoomSettings", "axisVideo:AxisVideoResolutionSettings", "axisVideo:AxisVideoEventCameraExt", "axisVideo:AxisVideoEventDiscoveryLeaf", "axisVideo:AxisVideoEventDiscoveryList", "axisVideo:AxisVideoEventDiscoveryPreferences", "axisVideo:AxisVideoEventFolder", "axisVideo:AxisVideoEventPointId", "axisVideo:AxisVideoEventProxyExt", "axisVideo:AxisVideoCameraDeviceId"};
    }

    public BValue upgrade(BValue origObj, BValue newObj) {
        Type typ = origObj.getType();
        if (!typ.getModule().getModuleName().equals("axisVideo")) {
            return null;
        }
        if (typ.getTypeName().equals("AxisVideoNetwork")) {
            return this.upgradeNetwork((BComplex)origObj);
        }
        if (typ.getTypeName().equals("AxisVideoCamera")) {
            return this.upgradeCamera((BComplex)origObj);
        }
        return AxisUpgrade.getInstance((String)"naxisVideo", (String)typ.getTypeName());
    }

    private BValue upgradeNetwork(BComplex origObj) {
        BAxisVideoNetwork network = new BAxisVideoNetwork();
        return network;
    }

    private BValue upgradeCamera(BComplex origObj) {
        BAxisVideoCamera dcam = new BAxisVideoCamera();
        String sdescr = AxisUpgrade.getString((BComplex)origObj, (String[])new String[]{"deviceId", "description"});
        dcam.getVideoDeviceId().setDescription(sdescr);
        String surl = AxisUpgrade.getString((BComplex)origObj, (String[])new String[]{"deviceId", "urlAddress"});
        ((BAxisVideoCameraDeviceId)dcam.getVideoDeviceId()).setUrlAddress(surl);
        String susername = AxisUpgrade.getString((BComplex)origObj, (String[])new String[]{"communicator", "credentials", "username"});
        BPassword spassword = (BPassword)AxisUpgrade.getValue((BComplex)origObj, (String[])new String[]{"communicator", "credentials", "password"});
        BAxisUserNameAndPassword userNamePasswrd = new BAxisUserNameAndPassword();
        userNamePasswrd.setUsername(susername);
        userNamePasswrd.setPassword(spassword);
        dcam.setCredentials(userNamePasswrd);
        boolean brtsp = ((BBoolean)AxisUpgrade.getValue((BComplex)origObj, (String[])new String[]{"communicator", "useRtspStream"})).getBoolean();
        dcam.setUseRtspStream(brtsp);
        boolean btcp = ((BBoolean)AxisUpgrade.getValue((BComplex)origObj, (String[])new String[]{"communicator", "useTcpTransport"})).getBoolean();
        dcam.setUseTcpTransport(btcp);
        String srtusername = AxisUpgrade.getString((BComplex)origObj, (String[])new String[]{"communicator", "rtspUsername"});
        BPassword srtpassword = (BPassword)AxisUpgrade.getValue((BComplex)origObj, (String[])new String[]{"communicator", "rtspPassword"});
        dcam.setRtspUsername(srtusername);
        dcam.setRtspPassword(srtpassword);
        String shostname = AxisUpgrade.getString((BComplex)origObj, (String[])new String[]{"communicator", "hostName"});
        dcam.setHostName(shostname);
        int iControlPort = AxisUpgrade.getInt((BComplex)origObj, (String[])new String[]{"communicator", "controlPort"});
        dcam.setControlPort(iControlPort);
        int idataPort = AxisUpgrade.getInt((BComplex)origObj, (String[])new String[]{"communicator", "dataPort"});
        dcam.setDataPort(idataPort);
        BValue v = AxisUpgrade.getValue((BComplex)origObj, (String[])new String[]{"pingParameters"});
        BVideoCameraInfo ci = NVideoUpgrade.upgradeCameraInfo((BComplex)((BComplex)v), null);
        dcam.setPtzSupport(ci);
        return dcam;
    }
}

