/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.event.enableEvents;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.event.BAxisVideoEventPointId;
import com.tridium.naxisVideo.event.BAxisVideoEventProxyExt;
import com.tridium.naxisVideo.event.enableEvents.AxisParameterUtil;
import com.tridium.naxisVideo.event.enableEvents.AxisSubscribeVideoMotionDetection;
import com.tridium.naxisVideo.event.enableEvents.EventActionUtil;
import com.tridium.naxisVideo.event.enableEvents.EventServerUtil;
import com.tridium.naxisVideo.event.enableEvents.MotionDetectionUtil;
import com.tridium.naxisVideo.event.enableEvents.MotionWindowUtil;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AxisEnableDetectionRunnable
implements Runnable {
    protected BAxisVideoCamera avCamera;
    protected BAxisVideoEventProxyExt avProxy;
    protected BAxisVideoEventPointId eventPointId;
    protected EventServerUtil eventServerUtil;
    protected MotionWindowUtil motionWindowUtil;
    protected String enableDetection;
    protected String eventServerId;
    protected String motionWindowId;
    public Logger axisLog = Logger.getLogger("NAxisVideo");

    public AxisEnableDetectionRunnable(BAxisVideoCamera avCamera, BAxisVideoEventProxyExt avProxy, boolean enableDetection) {
        this.avCamera = avCamera;
        this.avProxy = avProxy;
        this.eventServerUtil = new EventServerUtil(avCamera);
        this.motionWindowUtil = new MotionWindowUtil(avCamera);
        this.eventPointId = avProxy.getPointId();
        this.enableDetection = enableDetection ? "yes" : "no";
    }

    public void findOrAddEventServerEntry() throws UnknownHostException, AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToAddGroupException, AxisParameterUtil.UnableToUpdateParameterException {
        this.eventServerId = this.eventServerUtil.getIdForTheEventServerWithIpOfThisStationInAxisCam(this.eventPointId.getEventServer());
    }

    public void findOrAddMotionDetectionWindow() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToAddGroupException {
        this.motionWindowId = this.motionWindowUtil.getMotionWindowId(this.eventPointId.getMotionWindow());
    }

    public void findOrAddMotionStartedEvent() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToUpdateParameterException, AxisParameterUtil.UnableToAddGroupException {
        EventActionUtil actionStartUtil = new EventActionUtil(this.avCamera, this.eventPointId.getActionStart(), this.eventServerId);
        String actionStartId = actionStartUtil.getActionId();
        AxisParameterUtil.updateParameter(this.avCamera, actionStartId + ".Enabled", this.enableDetection);
        MotionDetectionUtil actionStartMotionDetectionUtil = new MotionDetectionUtil(this.avCamera, actionStartId, this.motionWindowId, this.avProxy.getEventTypeEnum());
        actionStartMotionDetectionUtil.triggerEventOnMotionStart();
    }

    public void findOrAddMotionStoppedEvent() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToUpdateParameterException, AxisParameterUtil.UnableToAddGroupException {
        EventActionUtil actionStopUtil = new EventActionUtil(this.avCamera, this.eventPointId.getActionStop(), this.eventServerId);
        String actionStopId = actionStopUtil.getActionId();
        AxisParameterUtil.updateParameter(this.avCamera, actionStopId + ".Enabled", this.enableDetection);
        MotionDetectionUtil actionStopMotionDetectionUtil = new MotionDetectionUtil(this.avCamera, actionStopId, this.motionWindowId, this.avProxy.getEventTypeEnum());
        actionStopMotionDetectionUtil.triggerEventOnMotionStop();
    }

    @Override
    public void run() {
        try {
            if (AxisSubscribeVideoMotionDetection.isVmdSupportedByCamera(this.avCamera)) {
                if (this.enableDetection.equalsIgnoreCase("yes")) {
                    List<String> topicList = AxisSubscribeVideoMotionDetection.getSupportedEventsOnAxisCamera(this.avCamera);
                    AxisSubscribeVideoMotionDetection.subscribeForVideoMotionDetection(this.avCamera, topicList);
                } else {
                    AxisSubscribeVideoMotionDetection.unsubscribeForVideoMotionDetection(this.avCamera);
                }
                this.avProxy.writeOk(this.avProxy.getWriteValue());
            } else {
                this.findOrAddEventServerEntry();
                this.findOrAddMotionDetectionWindow();
                this.findOrAddMotionStartedEvent();
                this.findOrAddMotionStoppedEvent();
                this.avProxy.writeOk(this.avProxy.getWriteValue());
            }
        }
        catch (Exception e) {
            this.axisLog.log(Level.SEVERE, "Exception raised while subscribing/Unsubscribing for motion detection events", e);
            this.avProxy.writeFail(e.toString());
        }
    }
}

