/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class DnsResourceRecord {
    private String domainName;
    private int type;
    private int rrClass;
    private int ttl;
    private int rdLength;
    protected byte[] rData;
    public static final int ADDRESS_TYPE = 1;
    public static final int SRV_TYPE = 33;
    public static final int TXT_TYPE = 16;

    public static DnsResourceRecord readResourceRecord(DataInput in) throws IOException {
        DnsResourceRecord record = new DnsResourceRecord();
        record.read(in);
        return record;
    }

    public void read(DataInput in) throws IOException {
        int octet;
        StringBuffer domainNameBuilder = new StringBuffer();
        while ((octet = in.readUnsignedByte()) != 0) {
            if (octet >= 192) {
                in.readUnsignedByte();
                break;
            }
            int length = octet;
            for (int i = 0; i < length; ++i) {
                domainNameBuilder.append((char)in.readUnsignedByte());
            }
            domainNameBuilder.append(".");
        }
        this.domainName = domainNameBuilder.toString();
        this.type = in.readUnsignedShort();
        this.rrClass = in.readUnsignedShort();
        this.ttl = in.readInt();
        this.readResourceData(in);
    }

    protected void readResourceData(DataInput in) throws IOException {
        this.rdLength = in.readUnsignedShort();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(this.rdLength);
        DataOutputStream dos = new DataOutputStream(bytes);
        for (int i = 0; i < this.rdLength; ++i) {
            dos.writeByte(in.readUnsignedByte());
        }
        this.rData = bytes.toByteArray();
    }

    public void write(DataOutput out) throws IOException {
        StringTokenizer st = new StringTokenizer(this.domainName, ".");
        while (st.hasMoreTokens()) {
            String label = st.nextToken();
            out.writeByte(label.length());
            out.writeBytes(label);
        }
        out.writeByte(0);
        out.writeShort(this.type);
        out.writeShort(this.rrClass);
        out.writeInt(this.ttl);
        out.writeShort(this.rdLength);
        out.write(this.rData);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public int getType() {
        return this.type;
    }

    public int getRecordClass() {
        return this.rrClass;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public int getResourceDataLength() {
        return this.rdLength;
    }

    public byte[] getResourceData() {
        return this.rData;
    }
}

