/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ndriver.discover.BNDiscoveryLeaf;
import com.tridium.ndriver.util.SfUtil;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAxisCameraDiscoveryLeaf
extends BNDiscoveryLeaf {
    public static final Property cameraName = BAxisCameraDiscoveryLeaf.newProperty((int)0, (String)"AxisCamera", (BFacets)SfUtil.incl());
    public static final Property macAddress = BAxisCameraDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Property address = BAxisCameraDiscoveryLeaf.newProperty((int)0, (String)"#.#.#.#", (BFacets)SfUtil.incl());
    public static final Property port = BAxisCameraDiscoveryLeaf.newProperty((int)0, (int)443, (BFacets)SfUtil.incl());
    public static final Type TYPE = Sys.loadType(BAxisCameraDiscoveryLeaf.class);
    public static final BIcon DISCOVERY_CAMERA_ICON = BIcon.make((String)"module://videoDriver/icons/camera.png");
    public static final TypeInfo[] VALID_DB_TYPES = new TypeInfo[]{BAxisVideoCamera.TYPE.getTypeInfo()};

    public String getCameraName() {
        return this.getString(cameraName);
    }

    public void setCameraName(String v) {
        this.setString(cameraName, v, null);
    }

    public String getMacAddress() {
        return this.getString(macAddress);
    }

    public void setMacAddress(String v) {
        this.setString(macAddress, v, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAxisCameraDiscoveryLeaf() {
    }

    public BAxisCameraDiscoveryLeaf(String name, String macAddress, String ipAddress, int port) {
        this.setCameraName(name);
        this.setMacAddress(macAddress);
        this.setAddress(ipAddress);
        this.setPort(port);
    }

    public TypeInfo[] getValidDatabaseTypes() {
        return VALID_DB_TYPES;
    }

    public String getDiscoveryName() {
        return SlotPath.escape((String)this.getCameraName());
    }

    public BIcon getDiscoveryIcon() {
        return DISCOVERY_CAMERA_ICON;
    }

    public boolean isExisting(BComponent target) {
        if (!(target instanceof BAxisVideoCamera)) {
            return false;
        }
        BAxisVideoCamera cam = (BAxisVideoCamera)target;
        String ipAddress = ((BAxisVideoCameraDeviceId)cam.getVideoDeviceId()).getUrlAddress();
        return ipAddress.equals(this.getAddress());
    }

    public void updateTarget(BComponent target) {
        BAxisVideoCamera cam = (BAxisVideoCamera)target;
        BAxisVideoCameraDeviceId deviceId = (BAxisVideoCameraDeviceId)cam.getVideoDeviceId();
        deviceId.setUrlAddress(this.getAddress());
        deviceId.setWebPort(this.getPort());
        deviceId.setDescription(this.getCameraName() + "(" + this.getMacAddress() + ")");
        cam.setHostName(this.getAddress() + "/axis-media/media.amp");
    }
}

