/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.comm;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.BAxisVideoNetwork;
import com.tridium.naxisVideo.event.BAxisVideoEventCameraExt;
import com.tridium.naxisVideo.event.BAxisVideoEventPointId;
import com.tridium.naxisVideo.event.BAxisVideoEventProxyExt;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.naxisVideo.util.AxisHttpUtil;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class BAxisVideoEventsReceiver
extends BComponent {
    public static final Property enabled = BAxisVideoEventsReceiver.newProperty((int)0, (boolean)true, null);
    public static final Property tcpIpPort = BAxisVideoEventsReceiver.newProperty((int)0, (int)9797, null);
    public static final Property socketTimeout = BAxisVideoEventsReceiver.newProperty((int)0, (int)60000, null);
    public static final Type TYPE = Sys.loadType(BAxisVideoEventsReceiver.class);
    protected ConnectionAcceptor rxEventsConnectionAcceptor;
    public static final Lexicon LEX = Lexicon.make(BAxisVideoEventsReceiver.class);

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public int getTcpIpPort() {
        return this.getInt(tcpIpPort);
    }

    public void setTcpIpPort(int v) {
        this.setInt(tcpIpPort, v, null);
    }

    public int getSocketTimeout() {
        return this.getInt(socketTimeout);
    }

    public void setSocketTimeout(int v) {
        this.setInt(socketTimeout, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    boolean isCommEnabled() {
        BAxisVideoNetwork network = (BAxisVideoNetwork)this.getParent();
        return !network.isDisabled() && !network.isFault() && this.getEnabled();
    }

    public void started() throws Exception {
        this.rxEventsConnectionAcceptor = new ConnectionAcceptor();
        this.rxEventsConnectionAcceptor.startAcceptor();
        super.started();
    }

    public void stopped() throws Exception {
        this.rxEventsConnectionAcceptor.stopAcceptor();
        super.stopped();
    }

    public Logger getLog() {
        return Logger.getLogger("axisVideo.cameraEvents." + this.getTcpIpPort());
    }

    public class ConnectionProcessor
    implements Runnable {
        protected Socket clientSocket;
        protected InputStream eventInput;
        protected String clientIpAddress;

        public ConnectionProcessor(Socket clientSocket) throws IOException {
            this.eventInput = clientSocket.getInputStream();
            this.clientSocket = clientSocket;
            this.clientIpAddress = clientSocket.getInetAddress().getHostAddress();
        }

        @Override
        public void run() {
            try {
                this.readEvent();
            }
            catch (IOException ioe) {
                if (BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) {
                    BAxisVideoEventsReceiver.this.getLog().fine(ioe.toString());
                }
            }
            finally {
                block13: {
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException ioe) {
                        if (!BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) break block13;
                        BAxisVideoEventsReceiver.this.getLog().fine(ioe.toString());
                    }
                }
            }
        }

        public void readEvent() throws IOException {
            String eventText;
            int eventTextLength;
            StringBuffer eventTextBuffer = new StringBuffer();
            int eventByte = this.eventInput.read();
            while (eventByte != -1) {
                if (eventByte > 48 || eventByte == 32) {
                    eventTextBuffer.append((char)eventByte);
                }
                eventByte = this.eventInput.read();
            }
            if (eventByte > 48 || eventByte == 32) {
                eventTextBuffer.append((char)eventByte);
            }
            if ((eventTextLength = (eventText = eventTextBuffer.toString()).length()) > 1 && eventText.charAt(0) == '\"' && eventText.charAt(eventTextLength - 1) == '\"') {
                eventText = eventText.substring(1, eventTextLength - 1);
            }
            if (eventText.length() > 0) {
                if (BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) {
                    BAxisVideoEventsReceiver.this.getLog().fine("Received action message: " + eventText + " from Axis camera " + this.clientIpAddress);
                }
                this.processCameraEvent(eventText);
            } else if (BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) {
                BAxisVideoEventsReceiver.this.getLog().fine("Receieved empty action message from Axis camera " + this.clientIpAddress);
            }
        }

        protected BAbsTime constructEventTime(String eventTimestamp) {
            int hour = Integer.parseInt(eventTimestamp.substring(0, 2));
            int minute = Integer.parseInt(eventTimestamp.substring(3, 5));
            int second = Integer.parseInt(eventTimestamp.substring(6, 8));
            int dayOfMonth = Integer.parseInt(eventTimestamp.substring(12, 14));
            int monthOfYear = Integer.parseInt(eventTimestamp.substring(15, 17));
            int year = Integer.parseInt(eventTimestamp.substring(18, 22));
            return BAbsTime.make((int)year, (BMonth)BMonth.make((int)(monthOfYear - 1)), (int)dayOfMonth, (int)hour, (int)minute, (int)second, (int)0, (BTimeZone)BTimeZone.GMT);
        }

        protected String getDvrIpAddressFromIpAddressBytes(BIpAddress ipAddressPort) {
            try {
                byte[] dvrIpAddressBytes = ipAddressPort.getInetAddress().getAddress();
                String dvrIpAddress = Integer.toString(dvrIpAddressBytes[0] & 0xFF) + '.' + Integer.toString(dvrIpAddressBytes[1] & 0xFF) + '.' + Integer.toString(dvrIpAddressBytes[2] & 0xFF) + '.' + Integer.toString(dvrIpAddressBytes[3] & 0xFF);
                return dvrIpAddress;
            }
            catch (Exception uhe) {
                return "UnknownHostException-&*^&^Y)&*(*(&*(&*^&TYJKHJKHJKHJKGHJTGdjkfhadjskf";
            }
        }

        protected boolean compareCameraIpAddress(BAxisVideoCamera avCamera) {
            BAxisVideoCameraDeviceId avCameraDeviceId = (BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId();
            String avUrlAddress = avCameraDeviceId.getUrlAddress();
            InetAddress avInetAddress = null;
            try {
                avInetAddress = InetAddress.getByName(avUrlAddress);
            }
            catch (Exception e) {
                avInetAddress = null;
            }
            InetAddress senderAddress = this.clientSocket.getInetAddress();
            return avInetAddress != null && avInetAddress.equals(senderAddress);
        }

        protected void updateEventPointsForCamera(BAxisVideoCamera avCamera, String actionMessage) {
            BAxisVideoEventCameraExt cameraEventsExt = avCamera.getEvents();
            BControlPoint[] eventPoints = cameraEventsExt.getPoints();
            for (int i = 0; i < eventPoints.length; ++i) {
                BVideoEvent videoEvent;
                BAxisVideoEventProxyExt avEventProxy = (BAxisVideoEventProxyExt)eventPoints[i].getProxyExt();
                BAxisVideoEventPointId avEventPointId = avEventProxy.getPointId();
                String actionStart = avEventPointId.getActionStart();
                String actionStop = avEventPointId.getActionStop();
                if (actionMessage.equals(actionStart)) {
                    if (avEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStarted) {
                        videoEvent = BVideoEvent.makeMotionStarted();
                    } else if (avEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStopped) {
                        videoEvent = BVideoEvent.makeMotionStopped();
                    } else {
                        videoEvent = BVideoEvent.makeOffNormalEvent();
                        videoEvent.setDescription(actionMessage);
                    }
                    avEventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
                    continue;
                }
                if (!actionMessage.equals(actionStop)) continue;
                if (avEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStarted) {
                    videoEvent = BVideoEvent.makeMotionStopped();
                } else if (avEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStopped) {
                    videoEvent = BVideoEvent.makeMotionStarted();
                } else {
                    videoEvent = BVideoEvent.makeNormalEvent();
                    videoEvent.setDescription(actionMessage);
                }
                avEventProxy.readOk((BStatusValue)new BVideoEventStatus(videoEvent));
            }
        }

        protected void updateEventPoint(String actionMessage) {
            BAxisVideoNetwork avNetwork = (BAxisVideoNetwork)BAxisVideoEventsReceiver.this.getParent();
            BDevice[] devices = avNetwork.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                if (!(devices[i] instanceof BAxisVideoCamera) || !this.compareCameraIpAddress((BAxisVideoCamera)devices[i])) continue;
                devices[i].pingOk();
                this.updateEventPointsForCamera((BAxisVideoCamera)devices[i], actionMessage);
            }
        }

        protected void processCameraEvent(String actionMessage) {
            this.updateEventPoint(actionMessage);
        }
    }

    public class ConnectionAcceptor
    extends Thread {
        protected boolean started;
        protected ServerSocket tcpServer;

        public ConnectionAcceptor() {
            super("axis.AcceptEvents");
            this.started = false;
        }

        public void startAcceptor() {
            this.started = true;
            this.start();
        }

        public void stopAcceptor() {
            block3: {
                this.started = false;
                this.interrupt();
                if (this.tcpServer != null) {
                    try {
                        this.tcpServer.close();
                    }
                    catch (IOException ioe) {
                        if (!BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) break block3;
                        BAxisVideoEventsReceiver.this.getLog().fine(ioe.toString());
                    }
                }
            }
        }

        @Override
        public void run() {
            while (this.started) {
                try {
                    if (BAxisVideoEventsReceiver.this.isCommEnabled()) {
                        this.tryAcceptEvent();
                        continue;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        BAxisVideoEventsReceiver.this.getLog().log(Level.WARNING, "Interrupted!", ie);
                        AxisHttpUtil.interruptCurrentThread();
                    }
                }
                catch (Exception e) {
                    BAxisVideoEventsReceiver.this.getLog().log(Level.SEVERE, e.toString(), e);
                }
            }
        }

        protected void tryAcceptEvent() {
            BAxisVideoNetwork axisVideoNetwork = (BAxisVideoNetwork)BAxisVideoEventsReceiver.this.getParent();
            try {
                this.acceptEvent();
                axisVideoNetwork.pingOk();
            }
            catch (BindException bindException) {
                axisVideoNetwork.pingFail(LEX.getText("axisVideoEventsReceiverPortError", new Object[]{Integer.toString(BAxisVideoEventsReceiver.this.getTcpIpPort())}));
            }
            catch (IOException ioe) {
                axisVideoNetwork.pingOk();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    BAxisVideoEventsReceiver.this.getLog().log(Level.WARNING, "Interrupted!", ie);
                    AxisHttpUtil.interruptCurrentThread();
                }
            }
        }

        protected void acceptEvent() throws IOException {
            this.tcpServer = new ServerSocket(BAxisVideoEventsReceiver.this.getTcpIpPort());
            Socket clientSocket = null;
            try {
                this.tcpServer.setSoTimeout(BAxisVideoEventsReceiver.this.getSocketTimeout());
                if (BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) {
                    BAxisVideoEventsReceiver.this.getLog().fine("Waiting for an Axis Video Camera to connect...");
                }
                clientSocket = this.tcpServer.accept();
                if (BAxisVideoEventsReceiver.this.getLog().isLoggable(Level.FINE)) {
                    BAxisVideoEventsReceiver.this.getLog().fine("Axis Video Camera Connection Established...processing in background");
                }
                BAxisVideoNetwork avNetwork = (BAxisVideoNetwork)BAxisVideoEventsReceiver.this.getParent();
                avNetwork.postAsync(new ConnectionProcessor(clientSocket));
            }
            finally {
                this.tcpServer.close();
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
        }
    }
}

