/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.exporters;

import com.tridium.history.ui.BHistoryTable;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.view.BIWbViewExporter;

public class BHistoryTableToXml
extends BExporter
implements BIWbViewExporter {
    public static final Type TYPE = Sys.loadType(BHistoryTableToXml.class);

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BXmlFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "xml";
    }

    public void export(ExportOp op) throws Exception {
        BHistoryTable historyTable = (BHistoryTable)op.get();
        BObject value = historyTable.getCurrentValue();
        BIHistory history = null;
        TableModel model = historyTable.getTableModel();
        int colCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        if (value instanceof BIHistory) {
            history = (BIHistory)value;
        } else if (value instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)value;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            history = (BIHistory)ord.resolve().get();
        } else {
            history = null;
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), "UTF-8"));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        out.write("<history>\n");
        out.write("<config>\n");
        if (history != null) {
            BHistoryConfig config = history.getConfig();
            SlotCursor cursor = config.getSlots();
            while (cursor.next()) {
                Slot slot = cursor.slot();
                out.write("<" + slot.getName() + " value=\"" + config.get(slot.asProperty()) + "\"/>\n");
            }
        }
        out.write("<schema>\n");
        for (int c = 0; c < colCount; ++c) {
            if (history != null) {
                BHistoryConfig config = history.getConfig();
                out.write("<column name=\"" + model.getColumnName(c) + "\" type=\"" + config.getSchema().getColumnType(c) + "\"/>\n");
                continue;
            }
            out.write("<column name=\"" + model.getColumnName(c) + "\"/>\n");
        }
        out.write("</schema>\n");
        out.write("</config>\n");
        out.write("<data>\n");
        for (int r = 0; r < rowCount; ++r) {
            out.write("<record>\n");
            for (int c = 0; c < colCount; ++c) {
                out.write("<value name=\"" + model.getColumnName(c) + "\" value=\"" + model.getValueAt(r, c).toString() + "\"/>\n");
            }
            out.write("</record>\n");
        }
        out.write("</data>\n");
        out.write("</history>\n");
        out.flush();
        out.close();
    }
}

