/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.BLiveHistoryChartEditor;
import javax.baja.chart.BChartPane;
import javax.baja.chart.Series;
import javax.baja.chart.TableSeries;
import javax.baja.chart.TrendFlags;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.gx.BBrush;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class LiveChartSeries
extends Series {
    private BLiveHistoryChartEditor historyChart;
    private static final int TIMESTAMP_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private SeriesColumn[] seriesCol;
    private SeriesData seriesData;
    private String seriesName;
    private int maxSize;
    private boolean showDelta;
    private boolean deltaEnabled;
    private BBrush brush;
    private BChartPane pane;
    private BAxisBound minAxisBound;
    private BAxisBound maxAxisBound;

    public LiveChartSeries(BLiveHistoryChartEditor historyChart, BChartPane pane, TableSeries tableSeries, String seriesName, int maxSize, boolean deltaEnabled, boolean showDelta) {
        this.historyChart = historyChart;
        this.setName(seriesName);
        this.setPane(pane);
        this.setMaxSize(maxSize);
        this.setDeltaEnabled(deltaEnabled);
        this.setShowDelta(showDelta);
        this.seriesCol = new SeriesColumn[2];
        this.seriesCol[0] = new SeriesColumn();
        this.seriesCol[1] = new SeriesColumn();
        this.seriesCol[0].setName(tableSeries.getColumnName(0));
        this.seriesCol[0].setDisplayName(tableSeries.getColumnDisplayName(0));
        this.seriesCol[0].setType(tableSeries.getColumnType(0));
        this.seriesCol[0].setFacets(tableSeries.getColumnFacets(0));
        this.seriesCol[0].setMin(tableSeries.getMin(0));
        this.seriesCol[0].setMax(tableSeries.getMax(0));
        this.seriesCol[1].setName(tableSeries.getColumnName(1));
        this.seriesCol[1].setDisplayName(tableSeries.getColumnDisplayName(1));
        this.seriesCol[1].setType(tableSeries.getColumnType(1));
        this.seriesCol[1].setFacets(tableSeries.getColumnFacets(1));
        this.initializeSeries(tableSeries);
    }

    public void initializeSeries(TableSeries tableSeries) {
        this.seriesData = new SeriesData();
        for (int index = 0; index < tableSeries.getRowCount(); ++index) {
            this.seriesData.addData(tableSeries.getValue(index, 0), tableSeries.getValue(index, 1), tableSeries.getTrendFlags(index));
        }
        this.computeMinMaxValue();
    }

    public void addData(Object time, Object value, int status, boolean isZoomed) {
        int trendFlags = 0;
        if (!BStatus.make((int)status).isValid()) {
            trendFlags = 4;
        }
        this.seriesData.addData(time, value, trendFlags);
        if (!TrendFlags.isHidden((int)trendFlags)) {
            Object val;
            int index;
            if (SortUtil.compare((Object)time, (Object)this.seriesCol[0].getMin()) < 0) {
                this.seriesCol[0].setMin(time);
            }
            if (SortUtil.compare((Object)time, (Object)this.seriesCol[0].getMax()) > 0) {
                this.seriesCol[0].setMax(time);
            }
            if ((index = this.seriesData.getSize() - 1) < 0) {
                index = 0;
            }
            if (SortUtil.compare((Object)(val = this.seriesData.getValue(index, true)), (Object)this.seriesCol[1].getMin()) < 0) {
                this.seriesCol[1].setMin(val);
            }
            if (SortUtil.compare((Object)val, (Object)this.seriesCol[1].getMax()) > 0) {
                this.seriesCol[1].setMax(val);
            }
            if (!isZoomed) {
                this.modified();
            }
        }
    }

    public String getName() {
        return this.seriesName;
    }

    public void setName(String seriesName) {
        this.seriesName = seriesName;
    }

    public String getColumnName(int col) {
        if (col == 0 || col == 1) {
            return this.seriesCol[col].getName();
        }
        return "Error-" + col;
    }

    public String getColumnDisplayName(int col) {
        if (col == 0 || col == 1) {
            return this.seriesCol[col].getDisplayName();
        }
        return this.getColumnName(col);
    }

    public Type getColumnType(int col) {
        if (col == 0 || col == 1) {
            return this.seriesCol[col].getType();
        }
        throw new IllegalArgumentException();
    }

    public BFacets getColumnFacets(int col) {
        if (col == 0 || col == 1) {
            return this.seriesCol[col].getFacets();
        }
        throw new IllegalArgumentException();
    }

    public int getRowCount() {
        return this.seriesData.getSize();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getTrendFlags(int row) {
        return this.seriesData.getTrendFlags(row);
    }

    public Object getValue(int row, int col) {
        if (col == 0) {
            return this.seriesData.getTime(row);
        }
        if (col == 1) {
            return this.seriesData.getValue(row, true);
        }
        throw new IllegalArgumentException();
    }

    public Object getLastValue() {
        return this.seriesData.getLastValue();
    }

    public Object getMin(int col) {
        if (col == 0) {
            return this.historyChart.getMinTime();
        }
        if (col == 1) {
            if (!this.deltaEnabled || this.showDelta || this.minAxisBound.isAuto()) {
                return this.seriesCol[col].getMin();
            }
            return this.minAxisBound.getValue().asObject();
        }
        throw new IllegalArgumentException();
    }

    public Object getMax(int col) {
        if (col == 0) {
            return BAbsTime.make((long)(((BAbsTime)this.historyChart.getMinTime()).getMillis() + this.historyChart.getTimeWindow().getMillis()), (BTimeZone)this.historyChart.getTimeZone());
        }
        if (col == 1) {
            if (!this.deltaEnabled || this.showDelta || this.maxAxisBound.isAuto()) {
                return this.seriesCol[col].getMax();
            }
            return this.maxAxisBound.getValue().asObject();
        }
        throw new IllegalArgumentException();
    }

    public Object getMinTime() {
        return this.seriesData.getTime(0);
    }

    public Object getMaxTime() {
        return this.seriesCol[0].getMax();
    }

    public void computeMinMaxValue() {
        this.seriesCol[1].computeMinMaxValue(this.seriesData);
    }

    public void refresh() {
        this.computeMinMaxValue();
        if (this.getPane().getCanvas().isZoomed()) {
            this.getPane().refresh();
        } else {
            this.modified();
        }
    }

    public BBrush getBrush() {
        return this.brush;
    }

    public void setBrush(BBrush brush) {
        this.brush = brush;
    }

    public void setMinAxisBound(BAxisBound axisBound) {
        this.minAxisBound = axisBound;
    }

    public void setMaxAxisBound(BAxisBound axisBound) {
        this.maxAxisBound = axisBound;
    }

    public BChartPane getPane() {
        return this.pane;
    }

    public void setPane(BChartPane pane) {
        this.pane = pane;
    }

    public void setShowDelta(boolean showDelta) {
        this.showDelta = showDelta;
    }

    public boolean getShowDelta() {
        return this.showDelta;
    }

    public boolean getDeltaEnabled() {
        return this.deltaEnabled;
    }

    public void setDeltaEnabled(boolean deltaEnabled) {
        this.deltaEnabled = deltaEnabled;
    }

    private class SeriesData {
        Object[] time;
        Object[] value;
        Object lastValue;
        Object firstDeltaValue;
        int[] trendFlags;
        int head = 0;
        int tail = 0;
        boolean bufferWrapped = false;

        private SeriesData() {
        }

        public int getSize() {
            if (!this.bufferWrapped) {
                return this.getTail() - this.getHead();
            }
            return LiveChartSeries.this.getMaxSize();
        }

        public Object getTime(int index) {
            if (this.time != null) {
                return this.time[this.getAdjustedPosition(index)];
            }
            return null;
        }

        public Object getValue(int index, boolean checkForDelta) {
            if (this.value != null) {
                if (checkForDelta && LiveChartSeries.this.getShowDelta() && LiveChartSeries.this.getDeltaEnabled()) {
                    BNumber currentValue = (BNumber)this.value[this.getAdjustedPosition(index)];
                    BNumber previousValue = (BNumber)this.getPreviousValue(index);
                    if (previousValue == null) {
                        return null;
                    }
                    return BDouble.make((double)(currentValue.getNumeric() - previousValue.getNumeric()));
                }
                return this.value[this.getAdjustedPosition(index)];
            }
            return null;
        }

        public Object getLastValue() {
            return this.lastValue;
        }

        public int getTrendFlags(int index) {
            if (this.trendFlags != null) {
                return this.trendFlags[this.getAdjustedPosition(index)];
            }
            return 0;
        }

        public void addData(Object newTime, Object newValue, int newTrendFlags) {
            try {
                if (this.getSize() == 0) {
                    this.time = new Object[LiveChartSeries.this.getMaxSize()];
                    this.value = new Object[LiveChartSeries.this.getMaxSize()];
                    this.trendFlags = new int[LiveChartSeries.this.getMaxSize()];
                    this.firstDeltaValue = newValue;
                } else {
                    this.firstDeltaValue = this.value[this.getAdjustedPosition(0)];
                }
                this.time[this.getTail()] = newTime;
                this.value[this.getTail()] = newValue;
                this.trendFlags[this.getTail()] = newTrendFlags;
                this.lastValue = newValue;
                this.incrementHeadAndTail();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private Object getPreviousValue(int index) {
            if (this.value != null) {
                if (index == 0) {
                    return this.firstDeltaValue;
                }
                int i = index - 1;
                if (TrendFlags.isStart((int)this.getTrendFlags(index)) || TrendFlags.isHidden((int)this.getTrendFlags(i))) {
                    return this.value[this.getAdjustedPosition(index)];
                }
                return this.value[this.getAdjustedPosition(i)];
            }
            return null;
        }

        private int getHead() {
            return this.head;
        }

        private int getTail() {
            return this.tail;
        }

        private int getAdjustedPosition(int index) {
            int position = 0;
            position = this.getHead() + index;
            if (position >= LiveChartSeries.this.getMaxSize()) {
                position -= LiveChartSeries.this.getMaxSize();
            }
            return position;
        }

        private void incrementHeadAndTail() {
            if (this.bufferWrapped) {
                this.head = this.getHead() + 1;
                if (this.head >= LiveChartSeries.this.getMaxSize()) {
                    this.head = 0;
                }
            }
            this.tail = this.getTail() + 1;
            if (this.tail >= LiveChartSeries.this.getMaxSize()) {
                this.bufferWrapped = true;
                this.tail = 0;
            }
        }
    }

    private class SeriesColumn {
        String displayName;
        String name;
        Type type;
        BFacets facets;
        Object min;
        Object max;

        private SeriesColumn() {
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Type getType() {
            return this.type;
        }

        public BFacets getFacets() {
            return this.facets;
        }

        public Object getMin() {
            return this.min;
        }

        public Object getMax() {
            return this.max;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDisplayName(String name) {
            this.displayName = name;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFacets(BFacets facets) {
            this.facets = facets;
        }

        public void setMin(Object min) {
            this.min = min;
        }

        public void setMax(Object max) {
            this.max = max;
        }

        public void computeMinMaxValue(SeriesData seriesData) {
            boolean first = true;
            for (int row = 0; row < seriesData.getSize(); ++row) {
                if (TrendFlags.isHidden((int)seriesData.getTrendFlags(row))) continue;
                Object val = seriesData.getValue(row, true);
                if (first) {
                    this.setMin(val);
                    this.setMax(val);
                    first = false;
                    continue;
                }
                if (SortUtil.compare((Object)val, (Object)this.getMin()) < 0) {
                    this.setMin(val);
                }
                if (SortUtil.compare((Object)val, (Object)this.getMax()) <= 0) continue;
                this.setMax(val);
            }
        }
    }
}

