/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui.chart;

import com.tridium.history.ui.chart.BHistoryList;
import com.tridium.history.ui.chart.HistoryItem;
import java.util.ArrayList;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.history.BIHistory;

public class HistoryListModel {
    protected BHistoryList owner;
    protected ArrayList<HistoryItem> list = new ArrayList();

    public int size() {
        return this.list.size();
    }

    public HistoryItem get(int index) {
        return this.list.get(index);
    }

    public void add(BIHistory history) {
        this.doAdd(new HistoryItem(history));
        this.changed();
    }

    public void add(HistoryItem item) {
        this.doAdd(item);
        this.changed();
    }

    public void add(BIHistory[] histories) {
        for (int i = 0; i < histories.length; ++i) {
            this.doAdd(new HistoryItem(histories[i]));
        }
        this.changed();
    }

    public void add(HistoryItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.doAdd(items[i]);
        }
        this.changed();
    }

    protected void doAdd(HistoryItem item) {
        this.assignColor(item);
        this.list.add(item);
    }

    public void moveUp(HistoryItem item) {
        int index = this.list.indexOf(item);
        if (index == 0) {
            return;
        }
        HistoryItem temp = this.list.get(index - 1);
        this.list.set(index - 1, this.list.get(index));
        this.list.set(index, temp);
        this.changed();
    }

    public void moveDown(HistoryItem item) {
        int index = this.list.indexOf(item);
        if (index == this.list.size() - 1) {
            return;
        }
        HistoryItem temp = this.list.get(index + 1);
        this.list.set(index + 1, this.list.get(index));
        this.list.set(index, temp);
        this.changed();
    }

    public void remove(HistoryItem item) {
        this.list.remove(item);
        this.changed();
    }

    public void clear() {
        this.list.clear();
        this.changed();
    }

    public HistoryListModel copy() {
        HistoryListModel copy = new HistoryListModel();
        for (int i = 0; i < this.size(); ++i) {
            copy.list.add(this.get(i).copy());
        }
        return copy;
    }

    public void changed() {
        if (this.owner != null) {
            this.owner.modelChanged();
        }
    }

    private void assignColor(HistoryItem item) {
        BBrush brush = item.getBrush();
        BColor[] cols = BChartPane.DEFAULT_COLORS;
        for (int i = 0; i < cols.length; ++i) {
            brush = cols[i].toBrush();
            boolean dup = false;
            for (int j = 0; j < this.size(); ++j) {
                BBrush testBrush;
                HistoryItem testItem = this.get(j);
                if (item == testItem || !brush.equals((Object)(testBrush = testItem.getBrush()))) continue;
                dup = true;
                break;
            }
            if (!dup) break;
        }
        item.setBrush(brush);
    }

    void setOwner(BHistoryList owner) {
        this.owner = owner;
    }
}

