/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.collection.BEmptyTable;
import com.tridium.history.ui.BOutlierParams;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.gx.BImage;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class HistoryEditorTableModel
extends CollectionTableModel {
    private static final BImage OUTLIER_ICON = BImage.make((BIcon)BIcon.make((String)"module://history/com/tridium/history/ui/icons/outlier.png"));
    private boolean[] modified;
    private boolean[] outliers;
    private BOutlierParams outlierParams;
    private boolean isOutlierType = true;

    public HistoryEditorTableModel(Context cx) {
        this((BITable<? extends BIObject>)new BEmptyTable(), cx);
    }

    public HistoryEditorTableModel(BITable<? extends BIObject> table, Context cx) {
        super(table, cx);
    }

    public void setCollection(BITable<? extends BIObject> collection) {
        super.setCollection(collection);
        BIRandomAccessTable table = this.getBITable();
        if (table.size() != 0) {
            BTrendRecord rec = (BTrendRecord)table.get(0).rowObject();
            this.isOutlierType = rec.getValueProperty().getType().is(BINumeric.TYPE);
        }
        this.modified = new boolean[table.size()];
        this.outliers = new boolean[table.size()];
        this.updateOutliers();
        this.updateTable();
    }

    public BTrendRecord getRecord(int row) {
        return (BTrendRecord)this.getBITable().get(row).rowObject();
    }

    public boolean modifyRecords(int[] rows, BBoolean hidden, BSimple newValue) {
        boolean anyModified = false;
        for (int i = 0; i < rows.length; ++i) {
            BSimple oldValue;
            BTrendRecord rec = this.getRecord(rows[i]);
            boolean recModified = false;
            if (hidden != null) {
                boolean hiddenVal = hidden.getBoolean();
                BTrendFlags flags = rec.getTrendFlags();
                if (flags.getBit(4) != hiddenVal) {
                    BTrendFlags newFlags = rec.getTrendFlags().set(4, hiddenVal);
                    rec.setTrendFlags(newFlags);
                    this.setModified(rows[i], true);
                    recModified = true;
                    anyModified = true;
                }
            }
            if (newValue != null && !(oldValue = (BSimple)rec.get(rec.getValueProperty())).equals((Object)newValue)) {
                rec.set(rec.getValueProperty(), (BValue)newValue);
                recModified = true;
                anyModified = true;
            }
            if (!recModified) continue;
            rec.setTrendFlags(rec.getTrendFlags().set(8, true));
            this.modified[rows[i]] = true;
        }
        if (anyModified) {
            this.updateOutliers();
        }
        this.updateTable();
        return anyModified;
    }

    public boolean isModified(int row) {
        if (this.modified == null) {
            return false;
        }
        return this.modified[row];
    }

    public void setModified(int row, boolean mod) {
        if (this.modified == null) {
            this.modified = new boolean[this.getRowCount()];
        }
        this.modified[row] = mod;
    }

    public void clearModified() {
        this.modified = new boolean[this.getBITable().size()];
    }

    public void setOutlierParams(BOutlierParams newParams) {
        this.outlierParams = newParams;
        this.updateOutliers();
    }

    public boolean isOutlier(int row) {
        if (this.outliers == null) {
            return false;
        }
        return this.outliers[row];
    }

    public int[] getOutliers() {
        if (this.outliers == null) {
            return new int[0];
        }
        int count = 0;
        for (int i = 0; i < this.outliers.length; ++i) {
            if (!this.outliers[i]) continue;
            ++count;
        }
        int[] result = new int[count];
        int r = 0;
        for (int i = 0; i < this.outliers.length && r < count; ++i) {
            if (!this.outliers[i]) continue;
            result[r++] = i;
        }
        return result;
    }

    public void clearOutliers() {
        this.outliers = new boolean[this.getBITable().size()];
        this.getTable().repaint();
    }

    public void selectOutliers() {
        this.getTable().getSelection().deselectAll();
        int[] outliers = this.getOutliers();
        if (outliers.length == 0) {
            return;
        }
        this.getTable().getSelection().select(outliers);
    }

    public static boolean isOutlier(BIRandomAccessTable<? extends BIObject> table, int index, int w, float p) {
        if (table == null || table.size() < 1) {
            return false;
        }
        int recCount = table.size();
        int startIndex = index - w / 2;
        int endIndex = startIndex + w - 1;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= recCount) {
            endIndex = recCount - 1;
        }
        if (index == startIndex) {
            return false;
        }
        if (index == endIndex) {
            return false;
        }
        int count = 0;
        double sum = 0.0;
        double[] temp = new double[endIndex - startIndex + 1];
        for (int i = startIndex; i <= endIndex; ++i) {
            if (i == index) continue;
            BTrendRecord rec = (BTrendRecord)table.get(i).rowObject();
            temp[count] = ((BDouble)rec.get(rec.getValueProperty())).getDouble();
            sum += temp[count];
            ++count;
        }
        if (count <= 1) {
            return false;
        }
        double[] values = new double[count];
        System.arraycopy(temp, 0, values, 0, count);
        double a = sum / (double)count;
        float sumSquareDeviations = 0.0f;
        for (int i = 0; i < count; ++i) {
            sumSquareDeviations = (float)((double)sumSquareDeviations + (values[i] - a) * (values[i] - a));
        }
        float s = (float)Math.sqrt(sumSquareDeviations / (float)(count - 1));
        BTrendRecord rec = (BTrendRecord)table.get(index).rowObject();
        double xVal = ((BDouble)rec.get(rec.getValueProperty())).getDouble();
        return !(xVal >= a - (double)(s * p)) || !(xVal <= a + (double)(s * p));
    }

    public void updateOutliers() {
        if (!this.isOutlierType || !this.outlierParams.getEnabled()) {
            this.clearOutliers();
            this.getTable().sizeColumnsToFit();
            return;
        }
        int w = this.outlierParams.getWindowSize();
        float p = this.outlierParams.getPercentStdDev();
        BIRandomAccessTable table = this.getBITable();
        int recCount = table.size();
        if (this.outliers == null) {
            this.outliers = new boolean[recCount];
        }
        for (int i = 0; i < recCount; ++i) {
            this.outliers[i] = HistoryEditorTableModel.isOutlier((BIRandomAccessTable<? extends BIObject>)table, i, w, p / 100.0f);
        }
        this.getTable().sizeColumnsToFit();
    }

    public BImage getRowIcon(int row) {
        return this.isOutlier(row) ? OUTLIER_ICON : null;
    }

    public int getColumnCount() {
        return super.getColumnCount() + 1;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        return super.getColumnName(col - 1);
    }

    public Object getValueAt(int rowIndex, int colIndex) {
        if (colIndex == 0) {
            return "";
        }
        return super.getValueAt(rowIndex, colIndex - 1);
    }

    public boolean isColumnSortable(int col) {
        return col == 1;
    }

    public void sortByColumn(int col, boolean ascending) {
        if (col != 1) {
            throw new UnsupportedOperationException();
        }
        super.sortByColumn(col, ascending);
        this.updateOutliers();
    }
}

