/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.collection.BRecordTable;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.log.BLogRecord;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.history.ui.HistorySourceSubscriber;
import com.tridium.history.ui.HistoryUiUtil;
import com.tridium.history.util.BICombinableHistory;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.BFilterSetDialog;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.file.BExportDialog;
import com.tridium.workbench.util.CollectionTableModel;
import java.lang.invoke.LambdaMetafactory;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

public class BHistoryTable
extends BWbView {
    public static final Property showTimeRangeEditor = BHistoryTable.newProperty((int)0, (boolean)true, null);
    public static final Property defaultTimeRange = BHistoryTable.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    public static final Property showDeltaEditor = BHistoryTable.newProperty((int)0, (boolean)true, null);
    public static final Property defaultDelta = BHistoryTable.newProperty((int)0, (boolean)false, null);
    public static final Property showLiveUpdates = BHistoryTable.newProperty((int)0, (boolean)true, null);
    public static final Property defaultLiveUpdates = BHistoryTable.newProperty((int)0, (boolean)false, null);
    public static final Action query = BHistoryTable.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BHistoryTable.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private static Map<String, State> states = new Hashtable<String, State>();
    private static final String lexRecords = lex.getText("records");
    private BToolBar toolbar;
    private BTitlePane tablePane;
    private boolean useBql = true;
    private BDynamicTimeRangeFE timeRangeEd;
    private BToggleButton deltaEd;
    private BTable table;
    private int lastRowCount = 0;
    private boolean sizedToFit = false;
    private boolean deltaEnabled;
    private Command filterCmd;
    private ToggleCommand deltaCmd;
    private BFilterSet filterSet;
    private Context tzContext;
    private BLabel liveUpdatesStatus;
    private BAbstractButton toolBarLiveUpdatesButton;
    private BToggleButton liveUpdatesToggle;
    private ToggleCommand liveUpdatesCmd;
    private HistoryTableSubscriber mySubscriber = new HistoryTableSubscriber(this);
    private BHistory currentHistory = null;
    private BIHistory cachedHistory = null;
    private BObject cachedValue = null;
    public Object syncObj = new Object();
    public BAbsTime lastTimestamp = BAbsTime.NULL;
    private BITable<? extends BHistoryRecord> lastQueryResult = null;
    private boolean lastUpdateState = false;
    private boolean tableReady = false;

    public boolean getShowTimeRangeEditor() {
        return this.getBoolean(showTimeRangeEditor);
    }

    public void setShowTimeRangeEditor(boolean v) {
        this.setBoolean(showTimeRangeEditor, v, null);
    }

    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    public boolean getShowDeltaEditor() {
        return this.getBoolean(showDeltaEditor);
    }

    public void setShowDeltaEditor(boolean v) {
        this.setBoolean(showDeltaEditor, v, null);
    }

    public boolean getDefaultDelta() {
        return this.getBoolean(defaultDelta);
    }

    public void setDefaultDelta(boolean v) {
        this.setBoolean(defaultDelta, v, null);
    }

    public boolean getShowLiveUpdates() {
        return this.getBoolean(showLiveUpdates);
    }

    public void setShowLiveUpdates(boolean v) {
        this.setBoolean(showLiveUpdates, v, null);
    }

    public boolean getDefaultLiveUpdates() {
        return this.getBoolean(defaultLiveUpdates);
    }

    public void setDefaultLiveUpdates(boolean v) {
        this.setBoolean(defaultLiveUpdates, v, null);
    }

    public void query() {
        this.invoke(query, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHistoryTable() {
        this.initCommands();
        BEdgePane main = new BEdgePane();
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY);
        this.timeRangeEd.setVisible(this.getShowTimeRangeEditor());
        this.deltaEd = new BToggleButton(this.deltaCmd, false, true);
        this.deltaEd.setSelected(false);
        this.deltaEd.setVisible(this.getShowDeltaEditor());
        this.liveUpdatesToggle = new BToggleButton(this.liveUpdatesCmd, false, true);
        this.liveUpdatesToggle.setSelected(false);
        this.liveUpdatesToggle.setVisible(this.getShowLiveUpdates());
        this.liveUpdatesStatus = new BLabel(lex.getText("history.liveUpdates.inProgress"), BHalign.right);
        this.liveUpdatesStatus.setVisible(false);
        this.toolbar = new BToolBar();
        this.rebuildToolbar();
        main.setTop((BWidget)new BBorderPane((BWidget)this.toolbar, 0.0, 0.0, 5.0, 0.0));
        main.getTop().setVisible(this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor());
        this.table = new BTable();
        this.table.setController((TableController)new HistoryTableController());
        this.tablePane = BTitlePane.makePane((String)"", (BTable)this.table, (String)lexRecords);
        main.setCenter((BWidget)this.tablePane);
        this.setContent((BWidget)main);
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)query);
    }

    public BToolBar getViewToolBar() {
        BToolBar tb = new BToolBar();
        tb.add("filter", this.filterCmd);
        this.toolBarLiveUpdatesButton = tb.add("liveUpdates", (Command)this.liveUpdatesCmd);
        tb.add("delta", (Command)this.deltaCmd);
        return tb;
    }

    public BTable getExportTable() {
        return this.table;
    }

    public BWidget getViewStatusBarSupplement() {
        return this.liveUpdatesStatus;
    }

    private void initCommands() {
        this.filterCmd = new Command((BWidget)this, BHistoryTable.lex.module, "command.filter"){

            public CommandArtifact doInvoke() {
                BHistoryTable.this.configFilters();
                return null;
            }
        };
        this.deltaCmd = new ToggleCommand((BWidget)this, BHistoryTable.lex.module, "command.delta"){

            public CommandArtifact doInvoke() {
                BHistoryTable.this.query();
                return null;
            }
        };
        this.liveUpdatesCmd = new ToggleCommand((BWidget)this, BHistoryTable.lex.module, "command.liveUpdates"){

            public CommandArtifact doInvoke() {
                if (!this.isEnabled()) {
                    return null;
                }
                boolean enableUpdates = this.isSelected();
                if (enableUpdates == BHistoryTable.this.lastUpdateState) {
                    return null;
                }
                BHistoryTable.this.lastUpdateState = enableUpdates;
                if (BHistoryTable.this.currentHistory != null) {
                    if (enableUpdates) {
                        BHistoryTable.this.liveUpdatesStatus.setVisible(true);
                        BHistoryTable.this.liveUpdatesStatus.relayoutSync();
                        BHistoryTable.this.currentHistory.subscribe((Subscriber)BHistoryTable.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(BHistoryTable.this.getCurrentContext()));
                    } else {
                        BHistoryTable.this.currentHistory.unsubscribe((Subscriber)BHistoryTable.this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(BHistoryTable.this.getCurrentContext()));
                    }
                }
                if (enableUpdates) {
                    this.icon = BHistoryChart.PAUSE_ICON;
                    if (BHistoryTable.this.toolBarLiveUpdatesButton != null) {
                        BHistoryTable.this.toolBarLiveUpdatesButton.setImage(BHistoryChart.PAUSE_ICON);
                    }
                    BHistoryTable.this.liveUpdatesToggle.setImage(BHistoryChart.PAUSE_ICON);
                } else {
                    BHistoryTable.this.liveUpdatesStatus.setVisible(false);
                    BHistoryTable.this.liveUpdatesStatus.relayoutSync();
                    this.icon = BHistoryChart.PLAY_ICON;
                    if (BHistoryTable.this.toolBarLiveUpdatesButton != null) {
                        BHistoryTable.this.toolBarLiveUpdatesButton.setImage(BHistoryChart.PLAY_ICON);
                    }
                    BHistoryTable.this.liveUpdatesToggle.setImage(BHistoryChart.PLAY_ICON);
                }
                return null;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public void doLoadValue(BObject value, Context context) {
        history = this.getHistory(value);
        if (history instanceof BHistory) {
            if (history instanceof BFoxHistory) {
                if (history != this.currentHistory) {
                    try {
                        this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                    }
                    catch (Exception var4_4) {
                        // empty catch block
                    }
                    this.currentHistory = (BHistory)history;
                }
            } else if (this.currentHistory != null) {
                if (this.currentHistory.getId().equals((Object)history.getId())) {
                    history = this.currentHistory;
                } else {
                    try {
                        this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                    }
                    catch (Exception var4_5) {
                        // empty catch block
                    }
                    this.currentHistory = (BHistory)history;
                }
            } else {
                this.currentHistory = (BHistory)history;
            }
        } else {
            if (this.currentHistory != null) {
                try {
                    this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(context));
                }
                catch (Exception var4_6) {
                    // empty catch block
                }
            }
            this.currentHistory = null;
        }
        this.tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)history.getConfig().getTimeZone()));
        this.tablePane.setTitle(history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
        recTypeSpec = history.getRecordType();
        type = recTypeSpec.getResolvedType();
        this.deltaEnabled = type.is(BNumericTrendRecord.TYPE);
        this.deltaCmd.setEnabled(this.deltaEnabled);
        liveUpdatesEnabled = this.currentHistory != null && this.currentHistory.canSubscribe(context) != false;
        this.liveUpdatesCmd.setEnabled(liveUpdatesEnabled);
        this.rebuildToolbar();
        space = (BHistorySpace)history.getSpace();
        this.useBql = true;
        try {
            BOrd.make((BOrd)space.getAbsoluteOrd(), (String)"bql:").resolve();
        }
        catch (Exception e) {
            this.useBql = false;
        }
        defRange = this.getDefaultTimeRange();
        if (defRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            conn = ((BHistorySpace)history.getSpace()).getConnection(null);
            var10_14 = null;
            try {
                this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.make((BAbsTime)conn.getFirstTimestamp(history), (BAbsTime)BAbsTime.NULL), this.tzContext);
                recordCount = conn.getRecordCount(history);
                lastTs = conn.getLastTimestamp(history);
                if (recordCount <= 500) ** GOTO lbl81
                now = Clock.time();
                if (now.dateEquals(lastTs)) {
                    this.timeRangeEd.loadValue((BObject)BDynamicTimeRange.TODAY, this.tzContext);
                }
                range = BDynamicTimeRange.make((BAbsTime)lastTs.timeOfDay(0, 0, 0, 0), (BAbsTime)BAbsTime.NULL);
                this.timeRangeEd.loadValue((BObject)range, this.tzContext);
            }
            catch (Throwable var11_17) {
                var10_14 = var11_17;
                throw var11_17;
            }
            finally {
                if (conn != null) {
                    if (var10_14 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable var11_16) {
                            var10_14.addSuppressed(var11_16);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        } else {
            this.timeRangeEd.loadValue((BObject)defRange, this.tzContext);
        }
lbl81:
        // 4 sources

        this.deltaEd.setSelected(this.deltaEnabled != false && this.getDefaultDelta() != false);
        this.liveUpdatesToggle.setSelected(liveUpdatesEnabled != false && this.getDefaultLiveUpdates() != false);
        this.toKey().ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, restoreState(java.lang.String ), (Ljava/lang/String;)V)((BHistoryTable)this));
        if (HistoryUiUtil.requiresSyncLoad(history, (BWidget)this, context)) {
            this.doQuery();
        } else {
            this.query();
        }
    }

    public void changed(Property p, Context cx) {
        if (p == showTimeRangeEditor || p == showDeltaEditor || p == showLiveUpdates) {
            this.rebuildToolbar();
        }
    }

    private void rebuildToolbar() {
        boolean a = this.currentHistory != null && this.getShowLiveUpdates();
        boolean b = this.deltaEnabled && this.getShowDeltaEditor();
        boolean c = this.getShowTimeRangeEditor();
        this.toolbar.removeAll();
        if (a) {
            this.toolbar.add(null, (BValue)this.liveUpdatesToggle);
        }
        if (a && (b || c)) {
            this.toolbar.add(null, (BValue)new BSeparator());
        }
        if (b) {
            this.toolbar.add(null, (BValue)this.deltaEd);
        }
        if (b && c) {
            this.toolbar.add(null, (BValue)new BSeparator());
        }
        if (c) {
            this.toolbar.add(null, (BValue)this.timeRangeEd);
        }
        if (this.getContent() instanceof BEdgePane) {
            ((BEdgePane)this.getContent()).getTop().setVisible(this.getShowDeltaEditor() || this.getShowLiveUpdates() || this.getShowTimeRangeEditor());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(cx));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
        return value;
    }

    public void doQuery() {
        this.doQuery(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doQuery(boolean liveUpdate) {
        Object object = this.syncObj;
        synchronized (object) {
            BWidgetShell shell = this.getShell();
            if (shell != null && !liveUpdate) {
                shell.enterBusy();
            }
            try {
                boolean append;
                BDynamicTimeRange timeRange;
                BRecordTable result;
                BIHistory history;
                block52: {
                    history = this.getHistory(this.getCurrentValue());
                    result = null;
                    timeRange = null;
                    append = false;
                    try {
                        timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
                        if (!liveUpdate || BAbsTime.NULL.equals((Object)this.lastTimestamp)) break block52;
                        BAbsTime start = this.lastTimestamp.add(BRelTime.make((long)1L));
                        BAbsTime current = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)history.getConfig().getTimeZone());
                        BAbsTime editorStart = timeRange.getStartTime(current);
                        if (BAbsTime.NULL.equals((Object)editorStart) || start.isAfter(editorStart)) {
                            BAbsTime editorEnd = timeRange.getEndTime(current);
                            if (!BAbsTime.NULL.equals((Object)editorEnd)) {
                                if (!start.isBefore(editorEnd)) return;
                            }
                            timeRange = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)editorEnd);
                            append = true;
                        }
                    }
                    catch (Exception e) {
                        if (liveUpdate) throw new BajaRuntimeException((Throwable)e);
                        BDialog.error((BWidget)this, (String)lex.getText("timerange.error"), (Object)lex.getText("timerange.checkRange"), (Throwable)e);
                        throw new BajaRuntimeException((Throwable)e);
                    }
                }
                BOrd historyOrd = history.getOrdInSession();
                String historyOrdParams = "?" + timeRange.toOrdParams() + ";delta=" + this.deltaCmd.isSelected();
                String historyOrdStr = historyOrd.toString();
                String nextSchemeOrdStr = "";
                int historySchemeIndex = historyOrdStr.indexOf("history:");
                int nextSchemeIndex = historyOrdStr.indexOf("|", historySchemeIndex);
                if (nextSchemeIndex > 0) {
                    nextSchemeOrdStr = historyOrdStr.substring(nextSchemeIndex);
                    historyOrdStr = historyOrdStr.substring(0, nextSchemeIndex);
                }
                BOrd historyQuery = BOrd.make((String)(historyOrdStr + historyOrdParams + nextSchemeOrdStr));
                if (this.useBql) {
                    String filterQual;
                    StringBuffer ordText = new StringBuffer(64);
                    ordText.append(historyQuery.toString()).append('|');
                    ordText.append("bql:select *");
                    StringBuffer predicate = new StringBuffer(64);
                    if (this.filterSet != null && (filterQual = this.filterSet.getPredicate()) != null && filterQual.length() > 0) {
                        if (predicate.length() != 0) {
                            predicate.append(" and ");
                        }
                        predicate.append(filterQual);
                    }
                    if (predicate.length() != 0) {
                        ordText.append(" where ").append(predicate.toString());
                    }
                    BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)BOrd.make((String)ordText.toString())).normalize();
                    result = (BITable)ord.resolve().get();
                } else {
                    BOrd ord = BOrd.make((BOrd)history.getAbsoluteOrd(), (BOrd)historyQuery).normalize();
                    result = (BRecordTable)ord.resolve().get();
                }
                if (append) {
                    if (result == null) {
                        result = this.lastQueryResult;
                    } else {
                        if (!(result instanceof BICombinableHistory)) {
                            this.doQuery(false);
                            return;
                        }
                        if (((BICombinableHistory)result).isEmpty()) {
                            result = this.lastQueryResult;
                        } else if (this.lastQueryResult instanceof BRecordTable && result instanceof BRecordTable) {
                            result = ((BRecordTable)this.lastQueryResult).combine(result);
                        } else if (this.lastQueryResult instanceof BHistoryTimeQuery && result instanceof BHistoryTimeQuery) {
                            result = ((BHistoryTimeQuery)this.lastQueryResult).combine((BHistoryTimeQuery)result);
                        } else if (this.lastQueryResult instanceof BHistoryDeltaQuery && result instanceof BHistoryDeltaQuery) {
                            result = ((BHistoryDeltaQuery)this.lastQueryResult).combine((BHistoryDeltaQuery)result);
                        }
                    }
                }
                int sortCol = this.table.getSortColumn();
                boolean resetModel = true;
                if (liveUpdate) {
                    TableModel outerModel = this.table.getModel();
                    TableModel innerModel = null;
                    if (outerModel instanceof DynamicTableModel) {
                        innerModel = ((DynamicTableModel)outerModel).getRootModel();
                    }
                    if (innerModel instanceof CollectionTableModel) {
                        ((CollectionTableModel)innerModel).setCollection((BITable)result);
                        resetModel = false;
                    }
                    if (sortCol != -1) {
                        outerModel.sortByColumn(sortCol, this.table.isSortAscending());
                    }
                }
                try {
                    this.loadData((BITable<? extends BHistoryRecord>)result, resetModel, history);
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)lex.getText("historyChart.noChartableValue"), (Throwable)e);
                    this.tableReady = true;
                    if (shell == null) return;
                    if (liveUpdate) return;
                    shell.exitBusy();
                    return;
                }
                if (result instanceof BICombinableHistory) {
                    this.lastTimestamp = ((BICombinableHistory)result).lastTimestamp();
                } else {
                    BAbsTime last = BAbsTime.NULL;
                    try (TableCursor cursor = result.cursor();){
                        while (cursor.next()) {
                            last = ((BHistoryRecord)cursor.get()).getTimestamp();
                        }
                    }
                    this.lastTimestamp = last;
                }
                this.lastQueryResult = result;
            }
            finally {
                this.tableReady = true;
                if (shell != null && !liveUpdate) {
                    shell.exitBusy();
                }
            }
            return;
        }
    }

    public void loadData(BITable<? extends BHistoryRecord> result, boolean resetModel, BIHistory history) {
        int sortCol = this.table.getSortColumn();
        if (resetModel) {
            CollectionTableModel model = new CollectionTableModel(result, this.getCurrentContext());
            int[] displayCols = null;
            if (this.table.getModel() instanceof DynamicTableModel) {
                DynamicTableModel m = (DynamicTableModel)this.table.getModel();
                displayCols = new int[m.getColumnCount()];
                for (int i = 0; i < m.getColumnCount(); ++i) {
                    displayCols[i] = m.toRootColumnIndex(i);
                }
            }
            DynamicTableModel outerModel = null;
            outerModel = displayCols != null ? new DynamicTableModel((TableModel)model, displayCols) : new DynamicTableModel((TableModel)model);
            if (sortCol != -1) {
                outerModel.sortByColumn(sortCol, this.table.isSortAscending());
            }
            this.table.setModel((TableModel)outerModel);
            this.table.relayout();
            this.relayout();
            if (!this.sizedToFit && this.lastRowCount == 0 && (result instanceof BICombinableHistory && !((BICombinableHistory)result).isEmpty() || Tables.hasRows(result))) {
                this.sizedToFit = true;
                this.table.sizeColumnsToFit();
            }
            this.updateTitle();
        }
        this.tablePane.tableModified();
    }

    public boolean isReady() {
        return this.tableReady;
    }

    private void updateTitle() {
        BIHistory history = this.getHistory(this.getCurrentValue());
        if (history == null) {
            this.tablePane.setTitle("");
            return;
        }
        String newTitle = history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX);
        if (this.filterSet != null && this.filterSet.anyActive()) {
            newTitle = newTitle + "*";
        }
        this.tablePane.setTitle(newTitle);
    }

    public void stopped() throws Exception {
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
        super.stopped();
    }

    public void configFilters() {
        if (this.table == null) {
            return;
        }
        if (this.filterSet == null) {
            BIRandomAccessTable itable = ((CollectionTableModel)((DynamicTableModel)this.table.getModel()).getRootModel()).getBITable();
            this.filterSet = this.buildFilterSet((BIRandomAccessTable<? extends BIObject>)itable);
        }
        BFilterSetDialog dialog = new BFilterSetDialog((BWidget)this, this.filterSet);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        if (dialog.isCancelled()) {
            return;
        }
        if (!dialog.isModified()) {
            return;
        }
        this.filterSet = dialog.getResult();
        this.query();
    }

    private BFilterSet buildFilterSet(BIRandomAccessTable<? extends BIObject> table) {
        ColumnList columns = table.getColumns();
        int colCount = columns.size();
        BFilterSet set = new BFilterSet();
        for (int i = 0; i < colCount; ++i) {
            Type colType = null;
            BFacets colFacets = null;
            try {
                AgentList agents;
                BObject proto;
                String typeSpec;
                Column col = columns.get(i);
                colFacets = col.getFacets();
                if (colFacets != null && (typeSpec = colFacets.gets("origType", null)) != null) {
                    colType = BTypeSpec.make((String)typeSpec).getResolvedType();
                }
                if (colType == null) {
                    colType = col.getType();
                }
                if ((proto = colType.getInstance()) instanceof BEnum && colFacets != null && colFacets.getFacet("range") != null) {
                    proto = BDynamicEnum.make((int)0, (BEnumRange)((BEnumRange)colFacets.getFacet("range")));
                }
                if ((agents = proto.getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() == 0) continue;
                BIBqlFilter filter = (BIBqlFilter)agents.getDefault().getInstance();
                filter.init(proto);
                BFilterEntry entry = new BFilterEntry(false, col.getDisplayName(this.getCurrentContext()), filter);
                set.add(col.getName(), (BValue)entry, 0, colFacets, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            set.remove("timestamp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return set;
    }

    protected BIHistory getHistory(BObject o) {
        if (o != this.cachedValue || this.cachedHistory == null) {
            this.cachedValue = o;
            if (o instanceof BIHistory) {
                this.cachedHistory = (BIHistory)o;
            } else if (o instanceof BHistoryExt) {
                BHistoryExt ext = (BHistoryExt)o;
                ext.lease(1);
                BHistoryConfig cfg = ext.getHistoryConfig();
                BHistoryId id = cfg.getId();
                BOrd base = ext.getAbsoluteOrd();
                BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
                this.cachedHistory = (BIHistory)ord.resolve().get();
            } else {
                this.cachedHistory = null;
            }
        }
        return this.cachedHistory;
    }

    private Optional<String> toKey() {
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return Optional.empty();
        }
        OrdTarget ordTarget = shell.getActiveOrdTarget();
        if (ordTarget == null) {
            return Optional.empty();
        }
        return Optional.of("" + ordTarget.getOrdWithoutViewQuery());
    }

    public void activated() {
        this.toKey().ifPresent(this::restoreState);
    }

    public void deactivated() {
        this.toKey().ifPresent(this::saveState);
        if (this.currentHistory != null) {
            try {
                this.currentHistory.unsubscribe((Subscriber)this.mySubscriber, HistorySourceSubscriber.makeAsyncContext(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentHistory = null;
        }
    }

    private void saveState(String key) {
        try {
            State state = new State();
            state.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
            state.filterSet = this.filterSet == null ? null : (BFilterSet)this.filterSet.newCopy(true);
            state.deltaState = this.deltaCmd.isSelected();
            state.liveUpdatesState = this.liveUpdatesCmd.isSelected();
            states.put(key, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restoreState(String key) {
        if (key == null) {
            return;
        }
        State state = states.get(key);
        if (state == null) {
            return;
        }
        this.timeRangeEd.loadValue((BObject)state.timeRange, this.tzContext);
        this.filterSet = state.filterSet;
        this.deltaEd.setSelected(state.deltaState);
        this.liveUpdatesToggle.setSelected(state.liveUpdatesState);
    }

    public BIHistory getHistory() {
        return this.getHistory(this.getCurrentValue());
    }

    public BDynamicTimeRange getRange() throws Exception {
        return (BDynamicTimeRange)this.timeRangeEd.saveValue();
    }

    public boolean isDelta() {
        return this.deltaCmd.isSelected();
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    static class HistoryTableSubscriber
    extends HistorySourceSubscriber {
        BHistoryTable table = null;

        public HistoryTableSubscriber(BHistoryTable table) {
            this.table = table;
        }

        @Override
        protected boolean allowCoalescedEvents() {
            return true;
        }

        @Override
        public void historySourceEvent(BComponentEvent event) {
            try {
                this.table.doQuery(true);
            }
            catch (Throwable throwable) {
                BasicContext cx = new BasicContext(this.table.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
                this.table.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", new Object[]{BAbsTime.now().toString((Context)cx)}));
                this.table.liveUpdatesStatus.relayoutSync();
                throw throwable;
            }
            BasicContext cx = new BasicContext(this.table.getCurrentContext(), BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
            this.table.liveUpdatesStatus.setText(lex.getText("history.liveUpdates.lastUpdate", new Object[]{BAbsTime.now().toString((Context)cx)}));
            this.table.liveUpdatesStatus.relayoutSync();
        }

        protected void unsubscribed(BComponent c, Context cx) {
            block20: {
                try {
                    BIHistory viewHistory = this.table.getHistory(this.table.getCurrentValue());
                    if (!(this.table.getShell() instanceof BWbShell)) break block20;
                    BOrd activeOrd = ((BWbShell)this.table.getShell()).getActiveOrd();
                    BOrd spaceOrd = BOrd.make((BOrd)activeOrd, (String)"history:");
                    BHistorySpace space = (BHistorySpace)spaceOrd.get();
                    try (HistorySpaceConnection conn = space.getConnection(cx);){
                        BIHistory spaceHistory = conn.getHistory(viewHistory.getId());
                        if (spaceHistory != viewHistory) {
                            this.table.cachedHistory = spaceHistory;
                            if (spaceHistory instanceof BHistory) {
                                this.table.currentHistory = (BHistory)spaceHistory;
                            } else {
                                this.table.currentHistory = null;
                            }
                            if (this.table.liveUpdatesCmd.isSelected()) {
                                this.table.liveUpdatesCmd.setSelected(false);
                                if (this.table.currentHistory != null) {
                                    this.table.liveUpdatesCmd.setSelected(true);
                                }
                            }
                            if (this.table.currentHistory == null) {
                                this.table.liveUpdatesCmd.setEnabled(false);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class State {
        BDynamicTimeRange timeRange;
        BFilterSet filterSet;
        boolean deltaState;
        boolean liveUpdatesState;

        private State() {
        }
    }

    class HistoryTableController
    extends TableController {
        HistoryTableController() {
        }

        protected BMenu makeOptionsMenu() {
            BTable table = this.getTable();
            BMenu menu = super.makeOptionsMenu();
            BMenuItem item = (BMenuItem)menu.get("export");
            if (item != null) {
                item.setCommand((Command)new ExportCommand(table.getParentWidget()));
            } else {
                menu.add("export", (Command)new ExportCommand(table.getParentWidget()));
            }
            return menu;
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            BIHistory history = BHistoryTable.this.getHistory(BHistoryTable.this.getCurrentValue());
            if (event.getClickCount() == 2) {
                BIRandomAccessTable recTab = ((CollectionTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel()).getBITable();
                BComplex rec = (BComplex)recTab.get(row).rowObject();
                Property[] props = rec.loadSlots().getPropertiesArray();
                int rows = props.length;
                int cols = 2;
                BGridPane recPane = new BGridPane(cols);
                recPane.setColorRows(true);
                recPane.setColumnGap(9.0);
                for (int i = 0; i < rows; ++i) {
                    BLabel label = new BLabel(rec.getDisplayName((Slot)props[i], null), BHalign.left);
                    label.setFont(Theme.label().getBoldText());
                    recPane.add(null, (BValue)label, null);
                    if (props[i].getType() == BFacets.TYPE) {
                        BFacets recData = (BFacets)rec.get(props[i]);
                        BGridPane dataPane = new BGridPane(2);
                        String[] keys = recData.list();
                        for (int k = 0; k < keys.length; ++k) {
                            BLabel facetLabel = new BLabel(keys[k], BHalign.left);
                            facetLabel.setFont(Theme.label().getBoldText());
                            dataPane.add(null, (BValue)facetLabel, null);
                            dataPane.add(null, (BValue)new BLabel(recData.getFacet(keys[k]).toString(), BHalign.left), null);
                        }
                        recPane.add(null, (BValue)dataPane, null);
                        continue;
                    }
                    if (props[i].getType() == BOrdList.TYPE) {
                        try {
                            BOrdList src = (BOrdList)rec.get(props[i]);
                            StringTokenizer tok = new StringTokenizer(src.encodeToString(), "|");
                            StringBuffer source = new StringBuffer();
                            BGridPane sourcePane = new BGridPane(1);
                            for (int k = src.size() - 1; k >= 0; --k) {
                                source.insert(0, SlotPath.unescape((String)src.get(k).encodeToString()));
                                if (!tok.hasMoreTokens()) continue;
                                source.insert(0, "\n");
                            }
                            tok = new StringTokenizer(source.toString());
                            boolean first = true;
                            while (tok.hasMoreTokens()) {
                                String lbl = "";
                                lbl = first ? tok.nextToken() : "-> " + tok.nextToken();
                                first = false;
                                sourcePane.add(null, (BValue)new BLabel(lbl));
                            }
                            BLabel sourceLabel = new BLabel("source", BHalign.left);
                            sourceLabel.setFont(Theme.label().getBoldText());
                            recPane.add(null, (BValue)sourcePane, null);
                        }
                        catch (Exception e) {
                            recPane.add(null, (BValue)new BLabel("unknown"), null);
                        }
                        continue;
                    }
                    BFacets slotFacets = null;
                    try {
                        slotFacets = (BFacets)history.getConfig().get(props[i].getName() + "Facets");
                    }
                    catch (Exception tok) {
                        // empty catch block
                    }
                    if (rec instanceof BLogRecord && (props[i] == BLogRecord.message || props[i] == BLogRecord.exception)) {
                        String value = rec.get(props[i]).toString((Context)slotFacets);
                        BTextEditorPane textWidget = null;
                        if (value.contains("\n")) {
                            textWidget = new BTextEditorPane();
                            textWidget.setText(rec.get(props[i]).toString((Context)slotFacets));
                            textWidget.getEditor().setEditable(false);
                        } else {
                            textWidget = new BTextField();
                            ((BTextField)textWidget).setText(rec.get(props[i]).toString((Context)slotFacets));
                            ((BTextField)textWidget).setEditable(false);
                        }
                        recPane.add(null, (BValue)textWidget, null);
                        continue;
                    }
                    recPane.add(null, (BValue)new BLabel(SlotPath.unescape((String)rec.get(props[i]).toString((Context)slotFacets)), BHalign.left), null);
                }
                BDialog.open((BWidget)BHistoryTable.this, (String)"History Record", (Object)recPane, (int)1);
            }
        }

        protected class ExportCommand
        extends Command {
            public ExportCommand(BWidget owner) {
                super(owner, (Lexicon)UiLexicon.bajaui(), "commands.export");
            }

            public CommandArtifact doInvoke() {
                try {
                    BExportDialog.invoke((BWbShell)BHistoryTable.this.getWbShell(), (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
    }
}

