/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.ui.BConfigDisplay;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbView;

public class BHistorySummaryView
extends BWbView {
    public static final Type TYPE = Sys.loadType(BHistorySummaryView.class);
    private static Lexicon lex = Lexicon.make((String)"history");
    private BConfigDisplay cfg;
    private BWbFieldEditor firstTs;
    private BWbFieldEditor lastTs;
    private BWbFieldEditor recCount;

    public Type getType() {
        return TYPE;
    }

    public BHistorySummaryView() {
        BEdgePane outer = new BEdgePane();
        BGridPane statusPane = new BGridPane(2);
        statusPane.setHalign(BHalign.left);
        statusPane.setValign(BValign.top);
        statusPane.setColumnAlign(BHalign.left);
        statusPane.setRowAlign(BValign.top);
        statusPane.setColumnGap(15.0);
        statusPane.add(null, (BValue)new BLabel(lex.getText("recordCount")));
        this.recCount = BWbFieldEditor.makeFor((BObject)BInteger.make((int)0));
        this.recCount.setReadonly(true);
        statusPane.add("recCount", (BValue)this.recCount);
        statusPane.add(null, (BValue)new BLabel(lex.getText("firstTimestamp")));
        this.firstTs = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        this.firstTs.setReadonly(true);
        statusPane.add("firstTs", (BValue)this.firstTs);
        statusPane.add(null, (BValue)new BLabel(lex.getText("lastTimestamp")));
        this.lastTs = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        this.lastTs.setReadonly(true);
        statusPane.add("lastTs", (BValue)this.lastTs);
        outer.setTop((BWidget)new BBorderPane((BWidget)statusPane, lex.getText("status")));
        BEdgePane inner = new BEdgePane();
        this.cfg = new BConfigDisplay();
        inner.setTop((BWidget)new BBorderPane((BWidget)this.cfg, lex.getText("configuration")));
        outer.setCenter((BWidget)inner);
        this.setContent((BWidget)outer);
    }

    protected void doLoadValue(BObject value, Context context) {
        BIHistory history = this.getHistory(value);
        if (history == null) {
            return;
        }
        BHistoryConfig config = history.getConfig();
        BasicContext tzContext = new BasicContext(context, BFacets.make((String)"TimeZone", (BIDataValue)config.getTimeZone(), (String)"showSeconds", (BIDataValue)BBoolean.TRUE));
        BHistorySpace space = (BHistorySpace)history.getSpace();
        try (HistorySpaceConnection conn = space.getConnection(context);){
            BHistorySummary summary = conn.getSummary(history);
            this.recCount.loadValue((BObject)BInteger.make((int)summary.getRecordCount()), context);
            this.firstTs.loadValue((BObject)summary.getFirstTimestamp(), (Context)tzContext);
            this.lastTs.loadValue((BObject)summary.getLastTimestamp(), (Context)tzContext);
        }
        this.cfg.loadValue((BObject)config);
        this.relayout();
    }

    protected BIHistory getHistory(BObject o) {
        if (o instanceof BIHistory) {
            return (BIHistory)o;
        }
        if (o instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)o;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            return (BIHistory)ord.resolve().get();
        }
        return null;
    }
}

