/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BHistoryIdFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BHistoryIdFE.class);
    private BFlowPane outer;
    private BLabel label = new BLabel("");
    private BGridPane editor;
    private BTextField devField = new BTextField("", 20);
    private BTextField nameField = new BTextField("", 20);

    public Type getType() {
        return TYPE;
    }

    public BHistoryIdFE() {
        this.editor = new BGridPane(4);
        BLabel slash = new BLabel("/");
        this.editor.add(null, (BValue)slash);
        this.editor.add(null, (BValue)this.devField);
        this.editor.add(null, slash.newCopy(true));
        this.editor.add(null, (BValue)this.nameField);
        this.outer = new BFlowPane();
        this.outer.add("history", (BValue)this.label);
        this.setContent((BWidget)this.outer);
        this.add("devModified", (BValue)new BLink((BComponent)this.devField, (Slot)BTextField.textModified, (Slot)setModified));
        this.add("nameModified", (BValue)new BLink((BComponent)this.nameField, (Slot)BTextField.textModified, (Slot)setModified));
    }

    protected void doLoadValue(BObject value, Context cx) {
        BHistoryId id = (BHistoryId)value;
        String unescaped = SlotPath.unescape((String)id.toString());
        this.label.setText(unescaped);
        this.devField.setText(SlotPath.unescape((String)id.getDeviceName()));
        this.nameField.setText(SlotPath.unescape((String)id.getHistoryName()));
        BWidget w = (BWidget)this.outer.get("history");
        if (this.isReadonly()) {
            if (w == null) {
                this.outer.add("history", (BValue)this.label);
            } else if (!(w instanceof BLabel)) {
                this.outer.remove("history");
                this.outer.add("history", (BValue)this.label);
            }
        } else if (w == null) {
            this.outer.add("history", (BValue)this.editor);
        } else if (!(w instanceof BGridPane)) {
            this.outer.remove("history");
            this.outer.add("history", (BValue)this.editor);
        }
        this.relayout();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BHistoryId current = (BHistoryId)this.getCurrentValue();
        if (current == null) {
            current = BHistoryId.NULL;
        }
        Object text = null;
        if (this.isReadonly()) {
            return current;
        }
        String devName = SlotPath.unescape((String)this.devField.getText().trim());
        String histName = SlotPath.unescape((String)this.nameField.getText().trim());
        return BHistoryId.make((String)devName, (String)histName);
    }

    public void doSetReadonly(boolean readOnly) {
        BWidget w = (BWidget)this.outer.get("history");
        if (w != null) {
            this.outer.remove("history");
        }
        BHistoryId current = BHistoryId.NULL;
        try {
            current = (BHistoryId)this.saveValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (readOnly) {
            if (current != null) {
                this.label.setText(SlotPath.unescape((String)current.toString()));
            }
            this.outer.add("history", (BValue)this.label);
        } else {
            if (current != null) {
                this.devField.setText(SlotPath.unescape((String)current.getDeviceName()));
                this.nameField.setText(SlotPath.unescape((String)current.getHistoryName()));
            }
            this.outer.add("history", (BValue)this.editor);
        }
        this.relayout();
    }
}

