/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.BHistoryExtStatusJob;
import com.tridium.history.ui.BHistoryNameDialog;
import com.tridium.history.ui.BHistorySystemTagsDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.util.CollectionTableModel;
import java.util.HashMap;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.DataTypes;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.BFormat;
import javax.baja.util.BNameList;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

public class BHistoryExtManager
extends BWbComponentView {
    public static final Action updateCommands = BHistoryExtManager.newAction((int)4, null);
    public static final Action restoreState = BHistoryExtManager.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BHistoryExtManager.class);
    private State state = new State();
    private static HashMap<String, State> states = new HashMap();
    private static final String[] ATTRS = new String[]{"parent.toPathString", "toPathString", "name", "historyConfig.id.historyDisplayName", "status.toString", "status.bits", "historyConfig.systemTags"};
    private static final int[] DISPLAY = new int[]{0, 2, 3, 4, 6};
    private static Lexicon lex = Lexicon.make((String)"history");
    private BTable table;
    private CollectionTableModel rootModel;
    private Command enableCollection;
    private Command disableCollection;
    private Command renameHistory;
    private Command editSystemTags;
    private IntHashMap nameMap;
    private BBorderPane topPane;
    private BJobBar jobBar;
    private BJob job;
    private boolean jobComplete;
    private BTitlePane tablePane;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public void restoreState() {
        this.invoke(restoreState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHistoryExtManager() {
        BEdgePane content = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.topPane = new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        content.setTop((BWidget)this.topPane);
        this.topPane.setVisible(false);
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.tablePane = BTitlePane.makePane((String)this.getTypeDisplayName(null), (BTable)this.table);
        content.setCenter((BWidget)this.tablePane);
        this.setContent((BWidget)content);
        this.enableCollection = new EnableCollection();
        this.enableCollection.setEnabled(false);
        this.disableCollection = new DisableCollection();
        this.disableCollection.setEnabled(false);
        this.renameHistory = new RenameHistory();
        this.renameHistory.setEnabled(false);
        this.editSystemTags = new EditSystemTags();
        this.editSystemTags.setEnabled(false);
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"historyExtManager.point");
        this.nameMap.put(2, (Object)"historyExtManager.extension");
        this.nameMap.put(3, (Object)"historyExtManager.historyName");
        this.nameMap.put(4, (Object)"historyExtManager.status");
        this.nameMap.put(6, (Object)"historyExtManager.systemTags");
    }

    public BMenu[] getViewMenus() {
        BMenu menu = new BMenu(lex.getText("historyExtManager.label"));
        menu.add("enable", this.enableCollection);
        menu.add("disable", this.disableCollection);
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("rename", this.renameHistory);
        menu.add("editSystemTags", this.editSystemTags);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        bar.add("enable", this.enableCollection);
        bar.add("disable", this.disableCollection);
        bar.add("rename", this.renameHistory);
        bar.add("editSystemTags", this.editSystemTags);
        return bar;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.updateTable();
        this.restoreState();
    }

    public void deactivated() {
        states.put(this.toKey(), this.currentState());
    }

    private void updateTable() {
        int sortCol;
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bqlOrd = BOrd.make((BOrd)authority, (String)this.query()).normalize();
        BITable itable = (BITable)bqlOrd.resolve().get();
        this.rootModel = new CollectionTableModel(itable, this.getCurrentContext());
        ColumnNameTableModel renameModel = new ColumnNameTableModel((TableModel)this.rootModel, this.nameMap, lex);
        DynamicTableModel hideModel = new DynamicTableModel((TableModel)renameModel, DISPLAY);
        hideModel.setColumnShowable(1, false);
        hideModel.setColumnShowable(5, false);
        TableModel lastHideModel = this.table.getModel();
        if (lastHideModel instanceof DynamicTableModel) {
            for (int i = 0; i < ((DynamicTableModel)lastHideModel).getRootColumnCount(); ++i) {
                if (i == 1 || i == 5) continue;
                hideModel.setShowColumn(i, ((DynamicTableModel)lastHideModel).showColumn(i));
            }
        }
        if ((sortCol = this.table.getSortColumn()) != -1) {
            hideModel.sortByColumn(sortCol, this.table.isSortAscending());
        }
        this.table.setModel((TableModel)hideModel);
        this.table.relayout();
        this.tablePane.tableModified();
    }

    private String query() {
        StringBuffer s = new StringBuffer(128);
        s.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ATTRS[i]);
        }
        s.append(" from history:HistoryExt");
        return s.toString();
    }

    public void doUpdateCommands() {
        boolean hasSelections = this.table.getSelection().getRow() != -1;
        this.enableCollection.setEnabled(hasSelections);
        this.disableCollection.setEnabled(hasSelections);
        this.renameHistory.setEnabled(hasSelections);
        this.editSystemTags.setEnabled(hasSelections);
    }

    public BHistoryExt getExtensionForRow(int rowIndex) {
        String path = this.rootModel.getBITable().get(rowIndex).cell(this.rootModel.getBITable().getColumns().get("toPathString")).toString();
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
        return (BHistoryExt)targetOrd.resolve().get();
    }

    public BOrd[] getSelectedOrds() {
        BIRandomAccessTable itable = this.rootModel.getBITable();
        int[] selectedRows = this.table.getSelection().getRows();
        int rowCount = selectedRows.length;
        BOrd[] ords = new BOrd[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            String path = itable.get(selectedRows[i]).cell(itable.getColumns().get("toPathString")).toString();
            ords[i] = BOrd.make((String)("station:|slot:" + path)).normalize();
        }
        return ords;
    }

    private BHistoryExt[] getSelectedExts() {
        BIRandomAccessTable itable = this.rootModel.getBITable();
        int[] selectedRows = this.table.getSelection().getRows();
        int rowCount = selectedRows.length;
        Column pathCol = itable.getColumns().get("toPathString");
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BHistoryExt[] exts = new BHistoryExt[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            String path = itable.get(selectedRows[i]).cell(pathCol).toString();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            exts[i] = (BHistoryExt)targetOrd.resolve().get();
        }
        return exts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCollectionEnabled(boolean enable) {
        BWidgetShell shell;
        BOrd[] selections = this.getSelectedOrds();
        if (selections.length == 0) {
            return;
        }
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd jobServiceOrd = BOrd.make((BOrd)authority, (String)"service:baja:JobService");
        BJobService jobService = (BJobService)jobServiceOrd.resolve().get();
        jobService.lease();
        BHistoryExtStatusJob[] jobs = (BHistoryExtStatusJob[])jobService.getChildren(BHistoryExtStatusJob.class);
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                if (jobs[i] == null) continue;
                jobs[i].lease();
                if (!jobs[i].isAlive()) continue;
                BDialog.error((BWidget)this, (String)lex.getText("historyExtManager.commandFail"), (Object)lex.getText("historyExtManager.statusJobExists"));
                return;
            }
        }
        if (!this.topPane.isVisible()) {
            this.topPane.setVisible(true);
            this.topPane.getParentWidget().relayout();
        }
        if ((shell = this.getShell()) != null) {
            shell.enterBusy();
        }
        try {
            BOrd serviceOrd = BOrd.make((BOrd)authority, (String)"service:history:HistoryService");
            BHistoryService service = (BHistoryService)serviceOrd.resolve().get();
            BVector extOrds = new BVector();
            for (int j = 0; j < selections.length; ++j) {
                extOrds.add("o" + j, (BValue)selections[j]);
            }
            if (enable) {
                this.setJob(service.enableExtensions(extOrds), service);
            } else {
                this.setJob(service.disableExtensions(extOrds), service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    public void renameHistory(int index) {
        if (index == -1) {
            index = this.table.getSelection().getRow();
        }
        if (index == -1) {
            return;
        }
        BHistoryExt extension = this.getExtensionForRow(index);
        if (extension == null) {
            return;
        }
        String deviceName = null;
        try {
            BOrd activeOrd = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd spaceOrd = BOrd.make((BOrd)activeOrd, (String)"history:");
            BHistorySpace space = (BHistorySpace)spaceOrd.get();
            deviceName = space.getDeviceName();
        }
        catch (Exception activeOrd) {
            // empty catch block
        }
        extension.lease(1);
        BHistoryNameDialog d = new BHistoryNameDialog((BWidget)this, extension.getHistoryConfig().getId().getHistoryName(), deviceName);
        d.setBoundsCenteredOnOwner();
        d.open();
        if (d.isCancelled()) {
            return;
        }
        extension.setHistoryName(BFormat.make((String)d.getHistoryName()));
        this.updateTable();
    }

    void editSystemTags(int index) throws Exception {
        if (index == -1) {
            index = this.table.getSelection().getRow();
        }
        if (index == -1) {
            return;
        }
        BHistoryExt extension = this.getExtensionForRow(index);
        if (extension == null) {
            return;
        }
        extension.lease(1);
        BNameList systemTags = extension.getHistoryConfig().getSystemTags();
        BHistorySystemTagsDialog d = new BHistorySystemTagsDialog((BWidget)this, systemTags);
        d.setBoundsCenteredOnOwner();
        d.open();
        if (d.isCancelled()) {
            return;
        }
        boolean replace = d.isReplaceSystemTags();
        systemTags = d.getSystemTags();
        BHistoryExt[] exts = this.getSelectedExts();
        BComponent.lease((BComponent[])exts, (int)1);
        int rowCount = exts.length;
        Transaction tx = ((BComponentSpace)this.getCurrentValueSpace()).newTransaction();
        for (int i = 0; i < rowCount; ++i) {
            try {
                BHistoryConfig config = exts[i].getHistoryConfig();
                BNameList oldTags = config.getSystemTags();
                BNameList newTags = systemTags;
                if (!replace) {
                    newTags = BNameList.union((BNameList)oldTags, (BNameList)newTags);
                }
                config.set(BHistoryConfig.systemTags, (BValue)newTags, (Context)tx);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tx.commit();
        this.updateTable();
    }

    private String toKey() {
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return null;
        }
        return "" + shell.getActiveOrdTarget().getOrdWithoutViewQuery();
    }

    public void doRestoreState() {
        String key = this.toKey();
        if (key == null) {
            return;
        }
        this.state = states.get(key);
        if (this.state == null) {
            this.state = new State();
        }
        this.table.getVscrollBar().setPosition(this.state.vscroll);
        this.table.getHscrollBar().setPosition(this.state.hscroll);
    }

    private State currentState() {
        State current = new State();
        current.vscroll = this.table.getVscrollBar().getPosition();
        current.hscroll = this.table.getHscrollBar().getPosition();
        return current;
    }

    public void handleComponentEvent(BComponentEvent event) {
        BJob job;
        super.handleComponentEvent(event);
        if (this.getJob() == event.getSourceComponent() && (job = (BJob)event.getSourceComponent()).getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(job);
        }
    }

    private BJob getJob() {
        return this.job;
    }

    private void setJob(BJob job) {
        this.job = job;
        this.jobComplete = false;
        this.registerForComponentEvents((BComponent)job);
        this.jobBar.load(job);
        if (job != null && job.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(job);
        }
    }

    private void setJob(BOrd jobOrd, BHistoryService service) throws Exception {
        service.getComponentSpace().sync();
        BJob job = (BJob)jobOrd.get((BObject)service);
        this.setJob(job);
    }

    private void jobComplete(BJob job) {
        this.updateTable();
    }

    private static class State {
        public int vscroll = 0;
        public int hscroll = 0;

        private State() {
        }

        public String toString() {
            return "vscroll=" + this.vscroll + ", hscroll=" + this.hscroll;
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        BIRandomAccessTable<? extends BIObject> lastTable = null;
        int statusCol = -1;

        private CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BIRandomAccessTable itable = BHistoryExtManager.this.rootModel.getBITable();
            ColumnList columns = itable.getColumns();
            if (itable != this.lastTable || this.statusCol == -1) {
                this.statusCol = columns.indexOf("status.bits");
            }
            BBrush fg = super.getForeground(cell);
            int statusBits = DataTypes.otoi((BIObject)itable.get(cell.row).cell(columns.get(this.statusCol)));
            BStatus status = BStatus.make((int)statusBits);
            if (!status.isOk()) {
                return ((BColor)status.getForegroundColor(null)).toBrush();
            }
            return fg;
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BIRandomAccessTable itable = BHistoryExtManager.this.rootModel.getBITable();
            ColumnList columns = itable.getColumns();
            if (itable != this.lastTable || this.statusCol == -1) {
                this.statusCol = columns.indexOf("status.bits");
            }
            BBrush bg = super.getBackground(cell);
            int statusBits = DataTypes.otoi((BIObject)itable.get(cell.row).cell(columns.get(this.statusCol)));
            BStatus status = BStatus.make((int)statusBits);
            if (!status.isOk()) {
                return ((BColor)status.getBackgroundColor(null)).toBrush();
            }
            return bg;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BIRandomAccessTable itable = BHistoryExtManager.this.rootModel.getBITable();
            ColumnList columns = itable.getColumns();
            String path = itable.get(row).cell(columns.get("toPathString")).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            ((BWbShell)this.getShell()).hyperlink(targetOrd);
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BIRandomAccessTable itable = BHistoryExtManager.this.rootModel.getBITable();
            ColumnList columns = itable.getColumns();
            String path = itable.get(row).cell(columns.get("toPathString")).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            BComponent target = (BComponent)targetOrd.get();
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeViewsMenu((BWidget)this.getTable(), (BObject)target)));
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)target)));
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new GotoPoint(row, (BITable<? extends BIObject>)itable));
            menu.add(null, (Command)new GotoHistory(row, (BITable<? extends BIObject>)itable));
            menu.add(null, (BValue)new BSeparator());
            menu.add("enable", BHistoryExtManager.this.enableCollection);
            menu.add("disable", BHistoryExtManager.this.disableCollection);
            menu.add(null, (BValue)new BSeparator());
            menu.add("rename", (Command)new RenameHistory(row));
            menu.add("editSystemTags", (Command)new EditSystemTags(row));
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }

    class EditSystemTags
    extends Command {
        int index;

        public EditSystemTags() {
            this(-1);
        }

        public EditSystemTags(int index) {
            super((BWidget)BHistoryExtManager.this, Sys.getModuleForClass(BHistoryExtManager.class), "historyExtManager.editSystemTags");
            this.index = index;
        }

        public CommandArtifact doInvoke() throws Exception {
            BHistoryExtManager.this.editSystemTags(this.index);
            return null;
        }
    }

    public class GotoHistory
    extends Goto {
        public GotoHistory(int row, BITable<? extends BIObject> itable) {
            super("historyExtManager.goto.history", row, itable);
        }

        @Override
        public BOrd getTargetOrd() {
            BHistoryExt ext = BHistoryExtManager.this.getExtensionForRow(this.row);
            ext.lease(1);
            BHistoryId id = ext.getHistoryConfig().getId();
            if (!id.isNull()) {
                return BOrd.make((String)("history:" + id.toString()));
            }
            return null;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int row, BITable<? extends BIObject> itable) {
            super("historyExtManager.goto.point", row, itable);
        }

        @Override
        public BOrd getTargetOrd() {
            return BOrd.make((String)("slot:" + BHistoryExtManager.this.rootModel.getBITable().get(this.row).cell(this.itable.getColumns().get("parent.toPathString")).toString()));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable<? extends BIObject> itable;

        public Goto(String key, int row, BITable<? extends BIObject> itable) {
            super((BWidget)BHistoryExtManager.this, Sys.getModuleForClass(BHistoryExtManager.class), key);
            this.row = row;
            this.itable = itable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BHistoryExtManager.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }

    public class RenameHistory
    extends Command {
        int index;

        public RenameHistory() {
            this(-1);
        }

        public RenameHistory(int index) {
            super((BWidget)BHistoryExtManager.this, Sys.getModuleForClass(BHistoryExtManager.class), "history.rename");
            this.index = index;
        }

        public CommandArtifact doInvoke() {
            BHistoryExtManager.this.renameHistory(this.index);
            return null;
        }
    }

    public class DisableCollection
    extends Command {
        public DisableCollection() {
            super((BWidget)BHistoryExtManager.this, Sys.getModuleForClass(BHistoryExtManager.class), "historyExtManager.disable");
        }

        public CommandArtifact doInvoke() {
            BHistoryExtManager.this.setCollectionEnabled(false);
            return null;
        }
    }

    public class EnableCollection
    extends Command {
        public EnableCollection() {
            super((BWidget)BHistoryExtManager.this, Sys.getModuleForClass(BHistoryExtManager.class), "historyExtManager.enable");
        }

        public CommandArtifact doInvoke() {
            BHistoryExtManager.this.setCollectionEnabled(true);
            return null;
        }
    }
}

