/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.ui;

import com.tridium.history.BHistoryFolder;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistorySpace;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.NavTreeNode;

public class BHistoryChooser
extends BWidget {
    public static final Action updateCommands = BHistoryChooser.newAction((int)4, null);
    public static final Topic selectionModified = BHistoryChooser.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BHistoryChooser.class);
    private BHistorySpace historySpace;
    private BNavTree tree;
    private BScrollPane treePane;
    private BPane buttonPane;
    private BList list;
    private Command addCmd;
    private Command removeCmd;
    private Command clearCmd;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHistoryChooser() {
        this(null);
    }

    public BHistoryChooser(BHistorySpace historySpace) {
        this.historySpace = historySpace;
        if (historySpace != null) {
            this.tree = this.makeTree(historySpace);
        }
        this.treePane = this.tree != null ? new BTreePane((BTree)this.tree) : new BTreePane();
        this.add("tree", (BValue)this.treePane);
        this.addCmd = new AddCommand();
        this.removeCmd = new RemoveCommand();
        this.clearCmd = new ClearCommand();
        BGridPane buttonGrid = new BGridPane(1);
        buttonGrid.setColumnAlign(BHalign.fill);
        buttonGrid.add("add", (BValue)new BButton(this.addCmd));
        buttonGrid.add("remove", (BValue)new BButton(this.removeCmd));
        buttonGrid.add("clear", (BValue)new BButton(this.clearCmd));
        this.buttonPane = new BBorderPane((BWidget)buttonGrid, 4.0, 4.0, 4.0, 4.0);
        this.add("buttons", (BValue)this.buttonPane);
        this.list = new BList();
        this.add("list", (BValue)this.list);
        if (historySpace != null) {
            int deviceCount = 0;
            try {
                deviceCount = historySpace.listDevices().length;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (deviceCount < 2) {
                this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
            }
            this.tree.relayout();
        }
    }

    public void setHistorySpace(BHistorySpace historySpace) {
        this.historySpace = historySpace;
        this.tree = this.makeTree(historySpace);
        this.treePane.setContent((BWidget)this.tree);
        this.treePane.relayout();
        int deviceCount = 0;
        deviceCount = historySpace.listDevices().length;
        if (deviceCount < 2) {
            this.tree.setExpanded(this.tree.getModel().getRoot(0), true);
        }
        this.tree.relayout();
    }

    private BNavTree makeTree(BHistorySpace historySpace) {
        BNavTree tree = new BNavTree((BINavNode)historySpace);
        tree.setMultipleSelection(true);
        tree.setController((TreeController)new HistoryTreeController());
        return tree;
    }

    public int getResultSize() {
        return this.list.getItemCount();
    }

    public void setSelection(BOrd[] selection) {
        this.list.removeAllItems();
        for (int i = 0; i < selection.length; ++i) {
            BINavNode navNode = (BINavNode)selection[i].get();
            this.list.addItem((Object)new Item(navNode));
        }
    }

    public BOrd[] getResult() {
        int count = this.list.getItemCount();
        BOrd[] result = new BOrd[count];
        for (int i = 0; i < count; ++i) {
            result[i] = ((Item)this.list.getItem(i)).getOrd();
        }
        return result;
    }

    public void computePreferredSize() {
        this.treePane.computePreferredSize();
        this.buttonPane.computePreferredSize();
        this.list.computePreferredSize();
        double w = this.buttonPane.getPreferredWidth();
        double listPrefW = this.list.getPreferredWidth();
        double h = Math.max(this.buttonPane.getPreferredHeight(), 200.0);
        this.setPreferredSize(w += Math.max(listPrefW, 200.0) * 2.0, h);
    }

    public void doLayout(BWidget[] kids) {
        this.buttonPane.computePreferredSize();
        double buttonPaneX = (this.getWidth() - this.buttonPane.getPreferredWidth()) / 2.0;
        this.treePane.setBounds(0.0, 0.0, buttonPaneX, this.getHeight());
        this.buttonPane.setBounds(buttonPaneX, (this.getHeight() - this.buttonPane.getPreferredHeight()) / 2.0, this.buttonPane.getPreferredWidth(), this.buttonPane.getPreferredHeight());
        double listX = buttonPaneX + this.buttonPane.getPreferredWidth();
        this.list.setBounds(listX, 0.0, this.getWidth() - listX, this.getHeight());
    }

    public void add() {
        TreeNode[] nodes = this.tree.getSelection().getNodes();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        boolean newSelection = false;
        for (int n = 0; n < nodes.length; ++n) {
            NavTreeNode selection = (NavTreeNode)nodes[n];
            BINavNode navNode = selection.getNavNode();
            if (navNode.getNavName().equalsIgnoreCase("history:///")) continue;
            Item item = new Item(navNode);
            boolean alreadySelected = this.list.indexOfItem((Object)item) != -1;
            boolean parentAlreadySelected = false;
            BINavNode parent = navNode.getNavParent();
            while (parent instanceof BISpaceNode) {
                Item parentItem = new Item(parent);
                if (this.list.indexOfItem((Object)parentItem) != -1) {
                    parentAlreadySelected = true;
                    break;
                }
                parent = parent.getNavParent();
            }
            if (navNode instanceof BHistoryDevice) {
                int count = this.list.getItemCount();
                for (int i = count - 1; i >= 0; --i) {
                    BINavNode existingItem = ((Item)this.list.getItem((int)i)).node;
                    if (!existingItem.getNavParent().getNavOrd().equals((Object)navNode.getNavOrd())) continue;
                    this.list.removeItem(i);
                }
            } else if (navNode instanceof BHistoryFolder) {
                int count = this.list.getItemCount();
                String myNavOrd = navNode.getNavOrd().toString() + "/";
                int myLen = myNavOrd.length();
                for (int i = count - 1; i >= 0; --i) {
                    BINavNode existingItem = ((Item)this.list.getItem((int)i)).node;
                    String existingNavOrd = existingItem.getNavOrd().toString();
                    if (existingNavOrd.length() <= myLen || !existingNavOrd.startsWith(myNavOrd)) continue;
                    this.list.removeItem(i);
                }
            }
            if (!alreadySelected && !parentAlreadySelected) {
                this.list.addItem((Object)item);
                newSelection = true;
            }
            if (!newSelection) continue;
            this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
        }
    }

    public void remove() {
        this.list.removeSelectedItems();
        this.list.getSelection().deselectAll();
        this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
    }

    public void clear() {
        this.list.removeAllItems();
        this.list.getSelection().deselectAll();
        this.fireSelectionModified(new BWidgetEvent(1, (BWidget)this));
    }

    public void doUpdateCommands() {
    }

    private class Item {
        BINavNode node;
        String display;

        public Item(BINavNode node) {
            this.node = node;
            this.display = ((BISpaceNode)node).getOrdInSpace().parse()[0].getBody();
        }

        public BOrd getOrd() {
            return ((BISpaceNode)this.node).getOrdInSpace();
        }

        public boolean equals(Object o) {
            if (o instanceof Item) {
                return ((Item)o).display.equals(this.display);
            }
            return false;
        }

        public String toString() {
            return this.display;
        }
    }

    private class HistoryTreeController
    extends TreeController {
        private HistoryTreeController() {
        }

        public void doSelectAction(TreeNode target, double x, double y) {
            BHistoryChooser.this.add();
        }
    }

    public class ClearCommand
    extends Command {
        public ClearCommand() {
            super((BWidget)BHistoryChooser.this, Sys.getModuleForClass(BHistoryChooser.class), "chooser.clear");
        }

        public CommandArtifact doInvoke() {
            BHistoryChooser.this.clear();
            return null;
        }
    }

    public class RemoveCommand
    extends Command {
        public RemoveCommand() {
            super((BWidget)BHistoryChooser.this, Sys.getModuleForClass(BHistoryChooser.class), "chooser.remove");
        }

        public CommandArtifact doInvoke() {
            BHistoryChooser.this.remove();
            return null;
        }
    }

    public class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BHistoryChooser.this, Sys.getModuleForClass(BHistoryChooser.class), "chooser.add");
        }

        public CommandArtifact doInvoke() {
            BHistoryChooser.this.add();
            return null;
        }
    }
}

