/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.pdf.BHistoryTableToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.PdfUtil;
import java.util.logging.Level;
import javax.baja.gx.BFont;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.util.Lexicon;

public class BPdfHistoryChart
extends BPdfFlowPane {
    public static final Type TYPE = Sys.loadType(BPdfHistoryChart.class);
    private static Lexicon lex = Lexicon.make((String)"pdf");

    public Type getType() {
        return TYPE;
    }

    public void fromWidget(BWidget widget, PdfOp op) {
        BDynamicTimeRange range;
        if (!(widget instanceof BHistoryChart)) {
            return;
        }
        BHistoryChart history = (BHistoryChart)widget;
        try {
            range = history.getRange();
        }
        catch (Exception e) {
            PdfUtil.log.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        BAbsTime now = BAbsTime.now();
        BTimeZone timeZone = (BTimeZone)history.getCurrentContext().getFacet("TimeZone");
        BAbsTime start = range.getStartTime(now, timeZone);
        BAbsTime end = range.getEndTime(now, timeZone);
        boolean isDelta = history.isDelta();
        BIHistory hist = history.getHistory();
        if (hist == null) {
            PdfUtil.log.log(Level.SEVERE, "Unable to resolve history for Chart: " + history.getNavName());
            return;
        }
        try (HistorySpaceConnection conn = ((BHistorySpace)hist.getSpace()).getConnection(null);){
            if (start == null || start.isNull()) {
                start = conn.getFirstTimestamp(hist);
            }
            if (end == null || end.isNull()) {
                end = conn.getLastTimestamp(hist);
            }
        }
        range = BDynamicTimeRange.make((BAbsTime)start, (BAbsTime)end);
        BHistoryChart chart = new BHistoryChart();
        chart.setDefaultTimeRange(range);
        chart.setDefaultDelta(isDelta);
        chart.loadValue((BObject)hist, (Context)op);
        try {
            while (!chart.isReady()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            PdfUtil.log.log(Level.SEVERE, e.getMessage(), e);
        }
        boolean isFromHistoryChartExporter = false;
        if (op != null) {
            isFromHistoryChartExporter = op.getBaseOrdTarget().get() instanceof BHistoryChart;
        }
        if (isFromHistoryChartExporter) {
            BLabel lblName = new BLabel("history:" + history.getHistory().getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX));
            BLabel lblRange = new BLabel(BHistoryTableToPdf.getRangeStr(range, (Context)op));
            lblName.setFont(BFont.make((String)lex.getText("pdf.propertySheetToPdf.font")));
            lblName.setHalign(BHalign.left);
            lblRange.setHalign(BHalign.left);
            this.add(null, (BValue)lblName);
            this.add(null, (BValue)lblRange);
            this.add(null, (BValue)new BLabel(""));
        }
        this.add(null, (BValue)chart.popChartPane());
        this.setupPane();
        if (!isFromHistoryChartExporter) {
            this.setLayout(widget.getLayout());
        }
    }
}

