/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.history.pdf.BAbstractHistoryChartToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.history.ui.HistoryUiUtil;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHistoryToChartPdf
extends BAbstractHistoryChartToPdf {
    public static final Type TYPE = Sys.loadType(BHistoryToChartPdf.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BHistoryChart getHistoryChart(PdfOp op) {
        BObject o = op.get();
        BIHistory history = null;
        if (o instanceof BIHistory) {
            history = (BIHistory)o;
        } else if (o instanceof BHistoryExt) {
            BHistoryExt ext = (BHistoryExt)o;
            ext.lease(1);
            BHistoryConfig cfg = ext.getHistoryConfig();
            BHistoryId id = cfg.getId();
            BOrd base = ext.getAbsoluteOrd();
            BOrd ord = BOrd.make((BOrd)base, (String)("history: " + id));
            history = (BIHistory)ord.resolve().get();
        }
        if (history == null) {
            return null;
        }
        BHistoryChart chart = new BHistoryChart();
        chart.loadValue((BObject)history, HistoryUiUtil.makeSyncLoadFacets((Context)op));
        return chart;
    }
}

