/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.history.pdf.BAbstractHistoryChartToPdf;
import com.tridium.history.ui.BHistoryChart;
import com.tridium.history.ui.chart.BHistoryChartBuilder;
import com.tridium.history.ui.chart.BReportViewer;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.view.BIWbViewExporter;

public class BHistoryChartToPdf
extends BAbstractHistoryChartToPdf
implements BIWbViewExporter {
    public static final Type TYPE = Sys.loadType(BHistoryChartToPdf.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BHistoryChart getHistoryChart(PdfOp op) {
        return (BHistoryChart)op.get();
    }

    @Override
    public void export(PdfOp op) throws Exception {
        BObject target = op.get();
        if (target instanceof BHistoryChart) {
            super.export(op);
        } else if (target instanceof BHistoryChartBuilder) {
            BHistoryChartBuilder hcb = (BHistoryChartBuilder)target;
            BReportViewer content = (BReportViewer)hcb.getContent();
            BWidget[] children = content.getChildWidgets();
            BWidget chartPane = children[0];
            BWidgetToPdf exporter = new BWidgetToPdf();
            PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
            exporter.renderDocument(chartPane, doc, op);
            OrdTarget hcbTarget = hcb.getWbShell().getActiveOrdTarget();
            ViewQuery viewQuery = hcbTarget.getViewQuery();
            String idText = null;
            if (viewQuery != null) {
                idText = viewQuery.getParameter("id", null);
            }
            int id = -1;
            try {
                id = Integer.parseInt(idText);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            content.load(id);
        }
    }
}

