/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.pdf;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.ui.BHistoryTable;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public abstract class BAbstractHistoryTableToPdf
extends BPdfExporter {
    public static final Type TYPE = Sys.loadType(BAbstractHistoryTableToPdf.class);
    private static Lexicon bqlLex = Lexicon.make((String)"bql");

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        BHistoryTable history = this.getHistoryTable(op);
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)history, doc, op);
    }

    protected abstract BHistoryTable getHistoryTable(PdfOp var1);

    public static String getRangeStr(BDynamicTimeRange range, Context cx) {
        BAbsTime now = BAbsTime.now();
        BTimeZone timeZone = range.getFixedStartTime().getTimeZone();
        BAbsTime start = range.getStartTime(now, timeZone);
        BAbsTime end = range.getEndTime(now, timeZone);
        StringBuffer s = new StringBuffer();
        if (start == null || start.isNull()) {
            s.append(bqlLex.getText("dynamicTimeRangeFE.epoch"));
        } else {
            s.append(start.toString(cx));
            s.append("  ").append(bqlLex.getText("dynamicTimeRangeFE.to")).append("  ");
        }
        if (end == null || end.isNull()) {
            s.append(bqlLex.getText("dynamicTimeRangeFE.now"));
        } else {
            s.append(end.toString(cx));
        }
        return s.toString();
    }
}

