/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.nav;

import com.tridium.history.BHistoryShortcuts;
import com.tridium.history.nav.BFilteredHistoryNavNode;
import java.util.ArrayList;
import javax.baja.history.BIHistory;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFilteredHistoryShortcuts
extends BFilteredHistoryNavNode {
    public static final Type TYPE = Sys.loadType(BFilteredHistoryShortcuts.class);

    public BFilteredHistoryShortcuts() {
    }

    public BFilteredHistoryShortcuts(BHistoryShortcuts shortcuts) {
        this(shortcuts, null);
    }

    public BFilteredHistoryShortcuts(BHistoryShortcuts shortcuts, IFilter filter) {
        this.historyNavNode = shortcuts;
        this.historyFilter = filter;
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String name) {
        BINavNode node = this.historyNavNode.getNavChild(name);
        if (node instanceof BHistoryShortcuts) {
            return new BFilteredHistoryShortcuts((BHistoryShortcuts)node, this.historyFilter);
        }
        return node;
    }

    @Override
    public BINavNode resolveNavChild(String name) {
        BINavNode node = this.historyNavNode.resolveNavChild(name);
        if (node instanceof BHistoryShortcuts) {
            return new BFilteredHistoryShortcuts((BHistoryShortcuts)node, this.historyFilter);
        }
        return node;
    }

    @Override
    public BINavNode[] getNavChildren() {
        BINavNode[] histories = this.historyNavNode.getNavChildren();
        if (histories.length == 0) {
            return histories;
        }
        ArrayList<BINavNode> result = new ArrayList<BINavNode>();
        for (int i = 0; i < histories.length; ++i) {
            if (histories[i] instanceof BHistoryShortcuts) {
                result.add(new BFilteredHistoryShortcuts((BHistoryShortcuts)histories[i], this.historyFilter));
                continue;
            }
            if (!(histories[i] instanceof BIHistory) || this.historyFilter != null && !this.historyFilter.accept((Object)histories[i])) continue;
            result.add(histories[i]);
        }
        return result.toArray(new BINavNode[result.size()]);
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

