/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.event;

import javax.baja.alarm.BAlarmClass;
import javax.baja.event.BEventService;
import javax.baja.event.BEventSource;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

public class BEventSourceFolder
extends BFolder {
    public static final Type TYPE = Sys.loadType(BEventSourceFolder.class);
    private static final BIcon icon = BIcon.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/folder.png"), BOrd.make((String)"module://event/icons/eventBadge.png")}));

    public Type getType() {
        return TYPE;
    }

    public void checkAdd(String newName, BValue value, int flags, BFacets facets, Context context) {
        if (this.isRunning() && value.getType().is(BEventSource.TYPE) && newName != null) {
            BEventService eventService = (BEventService)BOrd.make((String)"service:event:EventService").get((BObject)this);
            BEventSource existingSource = eventService.getEventSource(newName);
            if (newName.equals("defaultSource") || !existingSource.getName().equals("defaultSource")) {
                throw new LocalizableRuntimeException("event", "DuplicateEventSource", (Object[])new String[]{newName});
            }
        }
        super.checkAdd(newName, value, flags, facets, context);
    }

    public void checkRename(Property property, String newName, Context context) {
        if (this.isRunning() && property.getType().is(BAlarmClass.TYPE)) {
            BEventService eventService = (BEventService)BOrd.make((String)"service:event:EventService").get((BObject)this);
            BEventSource existingSource = eventService.getEventSource(newName);
            if (newName.equals("defaultSource") || !existingSource.getName().equals("defaultSource")) {
                throw new IllegalNameException("event", "DuplicateEventSource", (Object[])new String[]{newName});
            }
        }
        super.checkRename(property, newName, context);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BEventService || parent instanceof BEventSourceFolder;
    }

    public boolean isChildLegal(BComponent child) {
        if (child.getType().is(BFolder.TYPE) && !child.getType().is(TYPE)) {
            return false;
        }
        return super.isChildLegal(child);
    }

    public BIcon getIcon() {
        return icon;
    }
}

