/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platCrypto.certs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.baja.file.BAbstractFile;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.util.Store;

@NiagaraType
@NiagaraSingleton
public final class BPKCS7CertificateHandler
extends BObject
implements BICertificateFormatHandler {
    public static final BPKCS7CertificateHandler INSTANCE = new BPKCS7CertificateHandler();
    public static final Type TYPE = Sys.loadType(BPKCS7CertificateHandler.class);
    private static final LexiconModule LEX = LexiconModule.make(BPKCS7CertificateHandler.class);
    private static final String DEFAULT_PKCS7_EXTENSION = "p7b";
    private static final Set<String> PKCS7_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("p7b", "p7c")));
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeCertToFile(X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        if (certFile != null) {
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            try (BufferedOutputStream outputStream = new BufferedOutputStream(certFile.getOutputStream());){
                CMSProcessableByteArray cmsProcessableByteArray = new CMSProcessableByteArray(EMPTY_BYTE_ARRAY);
                JcaCertStore jcaCertStore = new JcaCertStore(Arrays.asList(certChain));
                cmsSignedDataGenerator.addCertificates((Store)jcaCertStore);
                CMSSignedData signedData = cmsSignedDataGenerator.generate((CMSTypedData)cmsProcessableByteArray);
                ((OutputStream)outputStream).write(signedData.getEncoded());
            }
            catch (CertificateEncodingException | CMSException e) {
                throw new IOException("Could not write certificate to file", e);
            }
        }
    }

    @Override
    public void writeKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, BAbstractFile certFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCertAndKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getSupportedFileExtensions() {
        return PKCS7_EXTENSIONS;
    }

    @Override
    public String getDefaultFileExtension() {
        return DEFAULT_PKCS7_EXTENSION;
    }

    @Override
    public String getCertificateFormatName(Context cx) {
        return LEX.get("cert.format.pkcs7.name", cx);
    }

    @Override
    public String getCertificateFormatFileTypeName(Context cx) {
        return LEX.get("cert.format.pkcs7.file.type", cx);
    }

    @Override
    public boolean supportsPrivateKey() {
        return false;
    }
}

