/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.platCrypto.certs;

import com.tridium.nre.security.SecurityInitializer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.baja.file.BAbstractFile;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS8EncryptedPrivateKeyInfoBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;

@NiagaraType
@NiagaraSingleton
public final class BPEMCertificateHandler
extends BObject
implements BICertificateFormatHandler {
    public static final Type TYPE = Sys.loadType(BPEMCertificateHandler.class);
    public static final BPEMCertificateHandler INSTANCE = new BPEMCertificateHandler();
    private static final LexiconModule LEX = LexiconModule.make(BPEMCertificateHandler.class);
    private static final String DEFAULT_PEM_EXTENSION = "pem";
    private static final Set<String> PEM_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("pem", "crt", "cer", "key")));

    public Type getType() {
        return TYPE;
    }

    @Override
    public void writeCertToFile(X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        if (certFile != null) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(certFile.getOutputStream());
                 JcaPEMWriter pem = new JcaPEMWriter((Writer)outputStreamWriter);){
                for (X509Certificate cert : certChain) {
                    pem.writeObject((Object)cert);
                }
            }
        }
    }

    @Override
    public void writeKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, BAbstractFile certFile) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(certFile.getOutputStream());
             JcaPEMWriter pem = new JcaPEMWriter((Writer)outputStreamWriter);){
            if (privateKey != null) {
                pem.writeObject(BPEMCertificateHandler.getConditionallyEncryptedPrivateKey(privateKey, encryptKey, encryptionKey));
            }
        }
        catch (OperatorCreationException e) {
            throw new IOException("Could not write certificate to file", e);
        }
    }

    @Override
    public void writeCertAndKeyToFile(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey, X509Certificate[] certChain, BAbstractFile certFile) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(certFile.getOutputStream());
             JcaPEMWriter pem = new JcaPEMWriter((Writer)outputStreamWriter);){
            if (privateKey != null) {
                pem.writeObject(BPEMCertificateHandler.getConditionallyEncryptedPrivateKey(privateKey, encryptKey, encryptionKey));
            }
            if (certChain != null) {
                for (X509Certificate cert : certChain) {
                    pem.writeObject((Object)cert);
                }
            }
        }
        catch (OperatorCreationException e) {
            throw new IOException("Could not write certificate to file", e);
        }
    }

    @Override
    public Set<String> getSupportedFileExtensions() {
        return PEM_EXTENSIONS;
    }

    @Override
    public String getDefaultFileExtension() {
        return DEFAULT_PEM_EXTENSION;
    }

    @Override
    public String getCertificateFormatName(Context cx) {
        return LEX.get("cert.format.pem.name", cx);
    }

    @Override
    public String getCertificateFormatFileTypeName(Context cx) {
        return LEX.get("cert.format.pem.file.type", cx);
    }

    @Override
    public boolean supportsPrivateKey() {
        return true;
    }

    private static Object getConditionallyEncryptedPrivateKey(PrivateKey privateKey, boolean encryptKey, BPassword encryptionKey) throws OperatorCreationException {
        if (encryptKey) {
            JcaPKCS8EncryptedPrivateKeyInfoBuilder pkcs8Builder = new JcaPKCS8EncryptedPrivateKeyInfoBuilder(privateKey);
            return pkcs8Builder.build(new JcePKCSPBEOutputEncryptorBuilder(NISTObjectIdentifiers.id_aes256_GCM).setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).build(AccessController.doPrivileged(() -> ((BPassword)encryptionKey).getValue()).toCharArray()));
        }
        return privateKey;
    }
}

