/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.util;

import com.tridium.crypto.core.cert.CertValidationResult;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.TridiumCertValidator;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platcrypto.core.IExtCryptoManager;
import com.tridium.util.BSessionInfo;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class BSslSessionInfo
extends BSessionInfo {
    public static final Type TYPE = Sys.loadType(BSslSessionInfo.class);
    private static Lexicon lex = Lexicon.make((String)"platCrypto");
    private NX509Certificate cert = null;
    private String protocol = null;
    private String cipherSuite = null;
    private boolean hostnameVerified = false;
    private boolean validCertChain = false;
    private boolean certExpired = false;

    public Type getType() {
        return TYPE;
    }

    public static BSessionInfo make(String name, BAbsTime connected, Socket socket, String username, String hostname, boolean isFips) {
        return new BSslSessionInfo(name, connected, socket, username, hostname, isFips);
    }

    public BSslSessionInfo() {
    }

    public BSslSessionInfo(String name, BAbsTime connected, Socket socket, String username, String hostname, boolean isFips) {
        super(name, connected, username, hostname, isFips);
        SSLSocket sslSocket = (SSLSocket)socket;
        SSLSession session = sslSocket.getSession();
        if (session != null) {
            this.cipherSuite = session.getCipherSuite();
            this.protocol = session.getProtocol();
            try {
                Certificate[] certs = session.getPeerCertificates();
                if (certs != null && certs.length > 0 && certs[0] instanceof java.security.cert.X509Certificate) {
                    this.cert = NX509Certificate.make((java.security.cert.X509Certificate)((java.security.cert.X509Certificate)certs[0]));
                }
                X509Certificate[] xcerts = session.getPeerCertificateChain();
                java.security.cert.X509Certificate[] tcerts = new java.security.cert.X509Certificate[xcerts.length];
                for (int i = 0; i < xcerts.length; ++i) {
                    java.security.cert.X509Certificate tempCertificate;
                    tcerts[i] = tempCertificate = NX509Certificate.convert((X509Certificate)xcerts[i]);
                }
                IExtCryptoManager mgr = (IExtCryptoManager)CertManagerFactory.getInstance();
                String hostName = session.getPeerHost();
                String host = session.getPeerHost() + ":" + session.getPeerPort();
                CertValidationResult result = TridiumCertValidator.validateCertificate((ICoreCryptoManager)mgr.getCoreCryptoManager(), (java.security.cert.X509Certificate[])tcerts, (String)hostName, (String)host);
                this.hostnameVerified = result.isHostnameVerified();
                this.validCertChain = result.isValidCertChain();
                this.certExpired = result.isCertExpired();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public BIcon getIdentityVerifiedIcon() {
        if (!this.hostnameVerified || !this.validCertChain || this.certExpired) {
            return BIcon.make((String)lex.getText("session.info.identityVerified.failed.icon"));
        }
        return BIcon.make((String)lex.getText("session.info.identityVerified.succeeded.icon"));
    }

    public String getIdentityVerifiedMessage() {
        if (!this.hostnameVerified || !this.validCertChain || this.certExpired) {
            StringBuffer buf = new StringBuffer(lex.getText("session.info.identityVerified.failed.title")).append("\n");
            if (!this.hostnameVerified) {
                buf.append(" - " + lex.getText("session.info.identityVerified.failed.hostnameMismatch")).append("\n");
            }
            if (!this.validCertChain) {
                buf.append(" - " + lex.getText("session.info.identityVerified.failed.certValidation")).append("\n");
            }
            if (this.certExpired) {
                buf.append(" - " + lex.getText("session.info.identityVerified.failed.certExpired")).append("\n");
            }
            return buf.toString();
        }
        return lex.getText("session.info.identityVerified.succeeded", new Object[]{this.cert.getIssuer()});
    }

    public BIcon getSessionEncryptedIcon() {
        return BIcon.make((String)lex.getText("session.info.sessionEncrypted.icon"));
    }

    public String getSessionEncryptedMessage() {
        return lex.getText("session.info.sessionEncrypted", new Object[]{this.name, CryptoSupport.getEncryptionBits((String)this.cipherSuite) + "", this.protocol, CryptoSupport.getEncryptionCipher((String)this.cipherSuite), CryptoSupport.getMessageAuthCipher((String)this.cipherSuite), CryptoSupport.getKeyExchangeCipher((String)this.cipherSuite)});
    }

    public String getProtocol() {
        return this.protocol;
    }

    public NX509Certificate getCertificate() {
        return this.cert;
    }

    public String toString(Context context) {
        return "SslSessionInfo: cert=" + this.cert.getSubject() + ", protocol=" + this.protocol + ", cipherSuite=" + this.cipherSuite + ", hostnameVerified=" + this.hostnameVerified + ", validCertChain=" + this.validCertChain + ", certExpired=" + this.certExpired;
    }
}

