/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.spy;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.crypto.core.provider.IProvider;
import com.tridium.crypto.core.provider.IProviderEntry;
import com.tridium.crypto.core.provider.IProviderSection;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.IExtCryptoManager;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ITrustStore;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

public class CryptoPlatformPage
extends SpyDir {
    private IExtCryptoManager service;

    public void write(SpyWriter out) throws Exception {
        ITrustStore iTrustStore;
        NX509Certificate x509cert;
        X509Certificate cert;
        Enumeration e;
        if (this.service == null) {
            this.service = (IExtCryptoManager)CertManagerFactory.getInstance();
        }
        try {
            ITrustStore systemCACerts = this.service.getSystemTrustStore();
            if (systemCACerts != null) {
                e = systemCACerts.aliases();
                while (e.hasMoreElements()) {
                    String string = (String)e.nextElement();
                    X509Certificate cert2 = systemCACerts.getCertificate(string);
                    if (!"X.509".equals(cert2.getType())) continue;
                    NX509CertificateEntry x509cert2 = NX509CertificateEntry.make((String)string, (X509Certificate[])new X509Certificate[]{cert2}, null);
                    this.add(string, (Spy)new CertificatePage(x509cert2));
                }
            }
        }
        catch (Exception systemCACerts) {
            // empty catch block
        }
        try {
            ITrustStore userCACerts = this.service.getUserTrustStore();
            if (userCACerts != null) {
                e = userCACerts.aliases();
                while (e.hasMoreElements()) {
                    String string = (String)e.nextElement();
                    X509Certificate cert2 = userCACerts.getCertificate(string);
                    if (!"X.509".equals(cert2.getType())) continue;
                    NX509CertificateEntry x509cert2 = NX509CertificateEntry.make((String)string, (X509Certificate[])new X509Certificate[]{cert2}, null);
                    this.add(string, (Spy)new CertificatePage(x509cert2));
                }
            }
        }
        catch (Exception userCACerts) {
            // empty catch block
        }
        out.startTable(true);
        out.trTitle((Object)"FIPS", 2);
        out.tr((Object)"fips mode", (Object)(SecurityInitializer.getInstance().isFips() ? "ON" : "OFF"));
        out.endTable();
        out.nbsp();
        out.nl();
        out.startTable(true);
        out.trTitle((Object)"Providers", 3);
        out.w((Object)"<tr>").th((Object)"Provider").th((Object)"Version").th((Object)"Description").w((Object)"</tr>\n");
        Enumeration<? extends IProvider> providers = this.service.getProviderInfo().providers();
        while (providers.hasMoreElements()) {
            IProvider provider = providers.nextElement();
            this.add(provider.getName(), (Spy)new ProviderPage(provider));
            out.w((Object)"<tr><td>").a(provider.getName()).w((Object)"</td>").td((Object)String.valueOf(provider.getVersion())).w((Object)"<td align='left'>").safe((Object)provider.getDescription()).w((Object)"</td>").w((Object)"</tr>");
        }
        out.endTable();
        out.nbsp();
        out.nl();
        out.startTable(true);
        String[] supportedCiphers = TlsCipherSuiteGroup.recommended.getEnabledCipherSuites();
        out.trTitle((Object)("Recommended Cipher Suites (" + supportedCiphers.length + " values)"), 5);
        out.w((Object)"<tr>").th((Object)"Name").th((Object)"Encryption Bits").th((Object)"Message Auth Cipher").th((Object)"Key Exchange Cipher").th((Object)"Encryption Cipher").w((Object)"</tr>\n");
        for (String supportedCipher1 : supportedCiphers) {
            if ("TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(supportedCipher1)) {
                out.tr((Object)supportedCipher1, (Object)"", (Object)"", (Object)"", (Object)"");
                continue;
            }
            out.tr((Object)supportedCipher1, (Object)Integer.toString(CryptoSupport.getEncryptionBits((String)supportedCipher1)), (Object)CryptoSupport.getMessageAuthCipher((String)supportedCipher1), (Object)CryptoSupport.getKeyExchangeCipher((String)supportedCipher1), (Object)CryptoSupport.getEncryptionCipher((String)supportedCipher1));
        }
        out.endTable();
        out.nbsp();
        out.nl();
        out.startTable(true);
        supportedCiphers = TlsCipherSuiteGroup.supported.getEnabledCipherSuites();
        out.trTitle((Object)("Supported Cipher Suites (" + supportedCiphers.length + " values)"), 5);
        out.w((Object)"<tr>").th((Object)"Name").th((Object)"Encryption Bits").th((Object)"Message Auth Cipher").th((Object)"Key Exchange Cipher").th((Object)"Encryption Cipher").w((Object)"</tr>\n");
        for (String supportedCipher : supportedCiphers) {
            if ("TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(supportedCipher)) {
                out.tr((Object)supportedCipher, (Object)"", (Object)"", (Object)"", (Object)"");
                continue;
            }
            out.tr((Object)supportedCipher, (Object)Integer.toString(CryptoSupport.getEncryptionBits((String)supportedCipher)), (Object)CryptoSupport.getMessageAuthCipher((String)supportedCipher), (Object)CryptoSupport.getKeyExchangeCipher((String)supportedCipher), (Object)CryptoSupport.getEncryptionCipher((String)supportedCipher));
        }
        out.endTable();
        ITrustStore iTrustStore2 = this.service.getSystemTrustStore();
        if (iTrustStore2 != null) {
            out.nbsp();
            out.nl();
            out.startTable(true);
            out.trTitle((Object)("Trusted System Certificates (" + iTrustStore2.size() + " certs)"), 4);
            out.w((Object)"<tr>").th((Object)"Alias").th((Object)"Issued To").th((Object)"Issued By").th((Object)"Expires").w((Object)"</tr>\n");
            Enumeration e2 = iTrustStore2.aliases();
            while (e2.hasMoreElements()) {
                String alias2 = (String)e2.nextElement();
                cert = iTrustStore2.getCertificate(alias2);
                if (!"X.509".equals(cert.getType())) continue;
                x509cert = NX509Certificate.make((X509Certificate)cert);
                out.w((Object)"<tr><td>").a(alias2).w((Object)"</td>").td((Object)alias2).td((Object)x509cert.getIssuer()).td((Object)x509cert.getNotAfter()).w((Object)"</tr>");
            }
            out.endTable();
        }
        if ((iTrustStore = this.service.getUserTrustStore()) != null) {
            out.nbsp();
            out.nl();
            out.startTable(true);
            out.trTitle((Object)("Trusted User Certificates (" + iTrustStore.size() + " certs)"), 4);
            if (iTrustStore.size() > 0) {
                out.w((Object)"<tr>").th((Object)"Alias").th((Object)"Issued To").th((Object)"Issued By").th((Object)"Expires").w((Object)"</tr>\n");
                Enumeration e3 = iTrustStore.aliases();
                while (e3.hasMoreElements()) {
                    String alias3 = (String)e3.nextElement();
                    cert = iTrustStore.getCertificate(alias3);
                    if (!"X.509".equals(cert.getType())) continue;
                    x509cert = NX509Certificate.make((X509Certificate)cert);
                    out.w((Object)"<tr><td>").a(alias3).w((Object)"</td>").td((Object)alias3).td((Object)x509cert.getIssuer()).td((Object)x509cert.getNotAfter()).w((Object)"</tr>");
                }
            }
            out.endTable();
        }
    }

    public static class ProviderEntryKeyComparator
    implements Comparator<IProviderEntry>,
    Serializable {
        @Override
        public int compare(IProviderEntry entry1, IProviderEntry entry2) {
            return entry1.getKey().compareTo(entry2.getKey());
        }
    }

    public static class ProviderSectionNameComparator
    implements Comparator<IProviderSection>,
    Serializable {
        @Override
        public int compare(IProviderSection section1, IProviderSection section2) {
            return section1.getName().compareTo(section2.getName());
        }
    }

    private static class ProviderPage
    extends SpyDir {
        private final IProvider provider;

        public ProviderPage(IProvider provider) {
            this.provider = provider;
        }

        public void write(SpyWriter out) throws Exception {
            out.startTable(true);
            out.trTitle((Object)"info", 2);
            out.tr((Object)"provider", (Object)this.provider.getName());
            out.tr((Object)"name", (Object)String.valueOf(this.provider.getVersion()));
            out.tr((Object)"description", (Object)this.provider.getDescription());
            out.endTable();
            ArrayList<IProviderSection> sections = Collections.list(this.provider.sections());
            sections.sort(new ProviderSectionNameComparator());
            for (IProviderSection section : sections) {
                out.nbsp();
                out.nl();
                out.startTable(true);
                out.trTitle((Object)section.getName(), 2);
                ArrayList<IProviderEntry> entries = Collections.list(section.entries());
                entries.sort(new ProviderEntryKeyComparator());
                for (IProviderEntry entry : entries) {
                    out.tr((Object)entry.getKey(), (Object)entry.getValue());
                }
                out.endTable();
            }
        }
    }

    private class CertificatePage
    extends SpyDir {
        private final NX509CertificateEntry cert;

        public CertificatePage(NX509CertificateEntry cert) {
            this.cert = cert;
        }

        public void write(SpyWriter out) throws Exception {
            if (CryptoPlatformPage.this.service == null) {
                CryptoPlatformPage.this.service = (IExtCryptoManager)CertManagerFactory.getInstance();
            }
            out.startTable(true);
            out.trTitle((Object)this.cert.getAlias(), 2);
            out.tr((Object)"Version", (Object)("v" + this.cert.getCertificate(0).getVersion()));
            out.tr((Object)"Serial Number", (Object)this.cert.getCertificate(0).getSerialNumber());
            out.tr((Object)"Issued By", (Object)this.cert.getCertificate(0).getIssuer());
            out.tr((Object)"Subject", (Object)this.cert.getCertificate(0).getSubject());
            out.tr((Object)"Not Before", (Object)this.cert.getCertificate(0).getNotBefore());
            out.tr((Object)"Not After", (Object)this.cert.getCertificate(0).getNotAfter());
            out.tr((Object)"Signature Algorithm", (Object)this.cert.getCertificate(0).getSignatureAlgorithm());
            out.tr((Object)"Basic Constraints", (Object)this.cert.getCertificate(0).getBasicConstraints());
            out.tr((Object)"Key Usage", (Object)this.cert.getCertificate(0).getKeyUsage());
            out.tr((Object)"Extended Key Usage", (Object)this.cert.getCertificate(0).getExtendedKeyUsage());
            out.tr((Object)"MD5 Fingerprint", (Object)this.cert.getCertificate(0).getMD5Fingerprint());
            out.tr((Object)"SHA1 Fingerprint", (Object)this.cert.getCertificate(0).getSHA1Fingerprint());
            out.endTable();
        }
    }
}

