/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.platcrypto.fox.ChannelBase;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.baja.security.crypto.ITrustStore;
import javax.baja.sys.BComponent;

public class ChannelTrustStore
extends ChannelBase
implements ITrustStore,
ICoreTrustStore {
    protected CryptoStoreId id;

    public ChannelTrustStore(BComponent parent, CryptoStoreId id) {
        super(parent);
        this.id = id;
    }

    public Enumeration<String> aliases() throws Exception {
        this.checkChannel();
        return this.channel.keyStoreAliases(this.id);
    }

    public boolean containsAlias(String alias) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreContainsAlias(this.id, alias);
    }

    public void deleteEntry(String alias) throws Exception {
        this.checkChannel();
        this.channel.keyStoreDeleteEntry(this.id, alias);
    }

    public X509Certificate getCertificate(String alias) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGetCertificate(this.id, alias);
    }

    public String getCertificateAlias(X509Certificate cert) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGetCertificateAlias(this.id, cert);
    }

    public X509Certificate[] getCertificateChain(String alias) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGetCertificateChain(this.id, alias);
    }

    public Date getCreationDate(String alias) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGetCreationDate(this.id, alias);
    }

    public boolean isCertificateEntry(String alias) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreIsCertificateEntry(this.id, alias);
    }

    public boolean isKeyEntry(String alias) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreIsKeyEntry(this.id, alias);
    }

    public void setCertificateEntry(String alias, X509Certificate cert) throws Exception {
        this.checkChannel();
        this.channel.keyStoreSetCertificateEntry(this.id, alias, cert);
    }

    public int size() throws Exception {
        this.checkChannel();
        return this.channel.keyStoreSize(this.id);
    }

    public long getLastModified() throws Exception {
        this.checkChannel();
        return 0L;
    }

    public boolean isReadOnly() throws Exception {
        this.checkChannel();
        return this.channel.storeIsReadOnly(this.id);
    }

    public void load() throws Exception {
        this.checkChannel();
    }

    public void save() throws Exception {
        this.checkChannel();
        this.channel.keyStoreSave(this.id);
    }

    public Enumeration<NX509CertificateEntry> getCertificates() throws Exception {
        this.checkChannel();
        return this.channel.keyStoreGetCertificates(this.id);
    }

    public String findCertificate(X509Certificate cert) throws Exception {
        this.checkChannel();
        return this.channel.keyStoreFindCertificate(this.id, cert);
    }

    public void deleteEntries(String[] aliases) throws Exception {
        this.checkChannel();
        this.channel.keyStoreDeleteEntries(this.id, aliases);
    }

    public KeyStore getKeyStore() throws Exception {
        throw new UnsupportedOperationException("can't access raw keystore remotely");
    }
}

