/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.fox.BCryptoChannel;
import java.io.IOException;
import javax.baja.naming.BLocalHost;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BComponent;

public abstract class ChannelBase {
    protected BCryptoChannel channel = null;
    private BComponent parent = null;

    public ChannelBase(BComponent parent) {
        this.parent = parent;
    }

    protected void checkChannel() throws IOException {
        if (!CertManagerFactory.isCertManagerActive()) {
            return;
        }
        this.channel = (BCryptoChannel)this.getFoxSession().getConnection().getChannels().get("crypto", BCryptoChannel.TYPE);
        if (this.channel == null) {
            throw new IOException("crypto fox channel not found");
        }
    }

    public boolean isSecure() {
        boolean rc = false;
        if (!CertManagerFactory.isCertManagerActive()) {
            return false;
        }
        this.channel = (BCryptoChannel)this.getFoxSession().getConnection().getChannels().get("crypto", BCryptoChannel.TYPE);
        if (this.channel != null) {
            if (this.getFoxSession().getUseFoxs()) {
                rc = true;
            } else if (this.getFoxSession().getHost() instanceof BLocalHost) {
                rc = true;
            }
        }
        return rc;
    }

    public BFoxSession getFoxSession() {
        return (BFoxSession)this.parent.getSession();
    }
}

