/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.fox;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NHostExemption;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.crypto.core.provider.IProvider;
import com.tridium.crypto.core.provider.NProvider;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Key;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.LexiconModule;

public class BCryptoChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BCryptoChannel.class);
    private ICoreCryptoManager service;
    private boolean validChannel;
    private static final Logger LOGGER = Logger.getLogger("crypto");
    private static final LexiconModule LEX = LexiconModule.make((String)"platCrypto");

    public Type getType() {
        return TYPE;
    }

    public BCryptoChannel() {
        super("crypto");
    }

    public void sessionOpened() throws Exception {
        if (this.isRunning()) {
            LOGGER.fine("pairing CertManagerService with CryptoChannel");
            BISession session = this.getSession();
            if (session instanceof BLocalHost) {
                ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
                this.service = CoreCryptoManager.get((ISecurityInfoProvider)provider);
            } else if (session instanceof BFoxSession) {
                this.service = new ChannelCryptoManager((BComponent)this);
            }
        }
    }

    public void sessionClosed(Throwable cause) throws Exception {
        LOGGER.fine("unpairing CertManagerService with CryptoChannel");
    }

    public FoxResponse process(FoxRequest req) throws Throwable {
        String command;
        switch (command = req.command) {
            case "keystore.serverAliases": {
                return this.keyStoreServerAliases(req);
            }
            case "keystore.aliases": {
                return this.keyStoreAliases(req);
            }
            case "keystore.containsAlias": {
                return this.keyStoreContainsAlias(req);
            }
            case "keystore.deleteEntry": {
                return this.keyStoreDeleteEntry(req);
            }
            case "keystore.getCertificate": {
                return this.keyStoreGetCertificate(req);
            }
            case "keystore.getCertificateAlias": {
                return this.keyStoreGetCertificateAlias(req);
            }
            case "keystore.getCertificateChain": {
                return this.keyStoreGetCertificateChain(req);
            }
            case "keystore.getCreationDate": {
                return this.keyStoreGetCreationDate(req);
            }
            case "keystore.getKey": {
                return this.keyStoreGetKey(req);
            }
            case "keystore.isCertificateEntry": {
                return this.keyStoreIsCertificateEntry(req);
            }
            case "keystore.isKeyEntry": {
                return this.keyStoreIsKeyEntry(req);
            }
            case "keystore.setCertificateEntry": {
                return this.keyStoreSetCertificateEntry(req);
            }
            case "keystore.setKeyEntry0": {
                return this.keyStoreSetKeyEntry0(req);
            }
            case "keystore.setKeyEntry1": {
                return this.keyStoreSetKeyEntry1(req);
            }
            case "keystore.size": {
                return this.keyStoreSize(req);
            }
            case "keystore.save": {
                return this.keyStoreSave(req);
            }
            case "keystore.getCertificates": {
                return this.keyStoreGetCertificates(req);
            }
            case "keystore.deleteEntries": {
                return this.keyStoreDeleteEntries(req);
            }
            case "keystore.findCertificate": {
                return this.keyStoreFindCertificate(req);
            }
            case "mgr.generateSelfSignedCert": {
                return this.mgrGenerateSelfSignedCert(req);
            }
            case "mgr.getCertGenerationStatus": {
                return this.mgrGetCertGenerationStatus(req);
            }
            case "keystore.generateCSR": {
                return this.keyStoreGenerateCSR(req);
            }
            case "provider.Providers": {
                return this.providerProviders(req);
            }
            case "provider.getProvider": {
                return this.providerGetProvider(req);
            }
            case "exemption.exemptions": {
                return this.exemptionExemptions(req);
            }
            case "exemption.setExemption": {
                return this.exemptionSetExemption(req);
            }
            case "exemption.deleteExemption": {
                return this.exemptionDeleteExemption(req);
            }
            case "exemption.getExemption": {
                return this.exemptionGetExemption(req);
            }
            case "exemption.save": {
                return this.exemptionSave(req);
            }
            case "store.isReadOnly": {
                return this.storeIsReadOnly(req);
            }
        }
        throw new InvalidCommandException(command);
    }

    protected final boolean useSharedKeyEncryption() {
        return true;
    }

    public Enumeration<String> keyStoreServerAliases(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("keystore.serverAliases");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        String[] aliases = resp.listStrings("alias");
        List<String> list = Arrays.asList(aliases);
        return Collections.enumeration(list);
    }

    private FoxResponse keyStoreServerAliases(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        Enumeration e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            if (!CertUtils.isValidServerCert((String)alias, (ICoreKeyStore)keyStore)) continue;
            resp.add("alias", alias);
        }
        return resp;
    }

    public Enumeration<String> keyStoreAliases(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("keystore.aliases");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        String[] aliases = resp.listStrings("alias");
        List<String> list = Arrays.asList(aliases);
        return Collections.enumeration(list);
    }

    private FoxResponse keyStoreAliases(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        Enumeration e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            resp.add("alias", alias);
        }
        return resp;
    }

    public boolean keyStoreContainsAlias(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.containsAlias");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("containsAlias");
    }

    private FoxResponse keyStoreContainsAlias(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("containsAlias", keyStore.containsAlias(req.getString("alias")));
        return resp;
    }

    public void keyStoreDeleteEntry(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.deleteEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        this.sendSync(req);
    }

    private FoxResponse keyStoreDeleteEntry(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id == CryptoStoreId.USER_EXEMPTION_STORE) {
            throw new IllegalArgumentException("Invalid store id passed to keyStoreDeleteEntry: " + id);
        }
        if (id == CryptoStoreId.USER_TRUST_STORE) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.deleteCommand", this.getSessionContext()));
        } else {
            BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        keyStore.deleteEntry(req.getString("alias"));
        return resp;
    }

    public X509Certificate keyStoreGetCertificate(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.getCertificate");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        String certString = resp.getString("certificate", null);
        if (certString != null) {
            return NX509Certificate.decodeFromString((String)certString);
        }
        return null;
    }

    private FoxResponse keyStoreGetCertificate(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate cert = keyStore.getCertificate(req.getString("alias"));
        if (cert != null) {
            resp.add("certificate", NX509Certificate.encodeToString((X509Certificate)cert));
        }
        return resp;
    }

    public String keyStoreGetCertificateAlias(CryptoStoreId id, X509Certificate cert) throws Exception {
        FoxRequest req = this.makeRequest("keystore.getCertificateAlias");
        req.add("cryptoStoreId", id.toString());
        req.add("certificate", NX509Certificate.encodeToString((X509Certificate)cert));
        FoxResponse resp = this.sendSync(req);
        return resp.getString("alias", null);
    }

    private FoxResponse keyStoreGetCertificateAlias(FoxRequest req) throws Exception {
        X509Certificate cert;
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        String alias = keyStore.getCertificateAlias(cert = NX509Certificate.decodeFromString((String)req.getString("certificate")));
        if (alias != null) {
            resp.add("alias", alias);
        }
        return resp;
    }

    public X509Certificate[] keyStoreGetCertificateChain(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.getCertificateChain");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        String[] certsStr = resp.listStrings("certificateChain");
        X509Certificate[] certs = null;
        if (certsStr.length > 0) {
            certs = new X509Certificate[certsStr.length];
            for (int i = 0; i < certsStr.length; ++i) {
                certs[i] = NX509Certificate.decodeFromString((String)certsStr[i]);
            }
        }
        return certs;
    }

    private FoxResponse keyStoreGetCertificateChain(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate[] certs = keyStore.getCertificateChain(req.getString("alias"));
        if (certs != null) {
            for (X509Certificate cert : certs) {
                resp.add("certificateChain", NX509Certificate.encodeToString((X509Certificate)cert));
            }
        }
        return resp;
    }

    public Date keyStoreGetCreationDate(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.getCreationDate");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return new Date(resp.getTime("creationDate"));
    }

    private FoxResponse keyStoreGetCreationDate(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        Date date = keyStore.getCreationDate(req.getString("alias"));
        resp.add("creationDate", date.getTime());
        return resp;
    }

    public Key keyStoreGetKey(CryptoStoreId id, String alias, char[] password) throws Exception {
        FoxRequest req = this.makeRequest("keystore.getKey");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        if (password != null) {
            String pass = new String(password);
            String encpass = this.encrypt(pass, this.makeEncodingContext(null));
            req.add("password", encpass);
        }
        FoxResponse resp = this.sendSync(req);
        Key key = null;
        boolean success = resp.getBoolean("success", false);
        if (success) {
            String encKey = this.decryptToString(resp.getString("key", null), this.makeDecodingContext(null));
            if (encKey != null) {
                key = NKey.decodeFromString((String)encKey);
            }
            return key;
        }
        throw new UnrecoverableKeyException("unable to recover key");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FoxResponse keyStoreGetKey(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        String encryptedPassword = req.getString("password", null);
        try (SecretChars secretChars = encryptedPassword != null ? SecretChars.fromSecretBytes((SecretBytes)this.decrypt(req.getString("password"), this.makeDecodingContext(null)), (Charset)StandardCharsets.UTF_8, (boolean)true) : null;){
            char[] password = encryptedPassword != null ? secretChars.get() : null;
            Key key = keyStore.getKey(req.getString("alias"), password);
            if (key != null) {
                resp.add("success", true);
                resp.add("key", this.encrypt(NKey.encodeToString((Key)key), this.makeEncodingContext(null)));
            } else {
                resp.add("success", false);
            }
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
        catch (UnrecoverableKeyException uke) {
            resp.add("success", false);
            return resp;
        }
    }

    public boolean keyStoreIsCertificateEntry(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.isCertificateEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("isCertificateEntry");
    }

    private FoxResponse keyStoreIsCertificateEntry(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("isCertificateEntry", keyStore.isCertificateEntry(req.getString("alias")));
        return resp;
    }

    public boolean keyStoreIsKeyEntry(CryptoStoreId id, String alias) throws Exception {
        FoxRequest req = this.makeRequest("keystore.isKeyEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("isKeyEntry");
    }

    private FoxResponse keyStoreIsKeyEntry(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("isKeyEntry", keyStore.isKeyEntry(req.getString("alias")));
        return resp;
    }

    public void keyStoreSetCertificateEntry(CryptoStoreId id, String alias, X509Certificate cert) throws Exception {
        FoxRequest req = this.makeRequest("keystore.setCertificateEntry");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        req.add("certificate", NX509Certificate.encodeToString((X509Certificate)cert));
        this.sendSync(req);
    }

    private FoxResponse keyStoreSetCertificateEntry(FoxRequest req) throws Exception {
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id.equals((Object)CryptoStoreId.USER_TRUST_STORE)) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.setCommand", this.getSessionContext()));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        X509Certificate cert = NX509Certificate.decodeFromString((String)req.getString("certificate"));
        keyStore.setCertificateEntry(req.getString("alias"), cert);
        return resp;
    }

    public void keyStoreSetKeyEntry0(CryptoStoreId id, String alias, byte[] key, X509Certificate[] chain) throws Exception {
        FoxRequest req = this.makeRequest("keystore.setKeyEntry0");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        req.add("key", this.encrypt(new SecretBytes(key, true), this.makeEncodingContext(null)));
        if (chain != null) {
            for (X509Certificate aChain : chain) {
                req.add("chain", NX509Certificate.encodeToString((X509Certificate)aChain));
            }
        }
        this.sendSync(req);
    }

    private FoxResponse keyStoreSetKeyEntry0(FoxRequest req) throws Exception {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        byte[] key = this.decrypt(req.getString("key"), this.makeDecodingContext(null)).get();
        X509Certificate[] certs = null;
        try {
            String[] chain = req.listStrings("chain");
            certs = new X509Certificate[chain.length];
            for (int i = 0; i < chain.length; ++i) {
                certs[i] = NX509Certificate.decodeFromString((String)chain[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        keyStore.setKeyEntry(req.getString("alias"), key, certs);
        return resp;
    }

    public void keyStoreSetKeyEntry1(CryptoStoreId id, String alias, Key key, char[] password, X509Certificate[] chain) throws Exception {
        Context cx = this.makeEncodingContext(null);
        FoxRequest req = this.makeRequest("keystore.setKeyEntry1");
        req.add("cryptoStoreId", id.toString());
        req.add("alias", alias);
        req.add("key", this.encrypt(NKey.encodeToString((Key)key), cx));
        if (password != null) {
            String pass = new String(password);
            String encpass = this.encrypt(pass, cx);
            req.add("password", encpass);
        }
        if (chain != null) {
            for (X509Certificate aChain : chain) {
                req.add("chain", NX509Certificate.encodeToString((X509Certificate)aChain));
            }
        }
        this.sendSync(req);
    }

    private FoxResponse keyStoreSetKeyEntry1(FoxRequest req) throws Exception {
        Context cx = this.makeDecodingContext(null);
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreKeyStore keyStore = (ICoreKeyStore)this.getCorrectCryptoStore(req);
        Key key = NKey.decodeFromString((String)this.decryptToString(req.getString("key"), cx));
        String encryptedPassword = req.getString("password", null);
        try (SecretChars secretChars = encryptedPassword != null ? SecretChars.fromSecretBytes((SecretBytes)this.decrypt(req.getString("password"), cx), (Charset)StandardCharsets.UTF_8, (boolean)true) : null;){
            char[] password = encryptedPassword != null ? secretChars.get() : null;
            X509Certificate[] certs = null;
            try {
                String[] chain = req.listStrings("chain");
                certs = new X509Certificate[chain.length];
                for (int i = 0; i < chain.length; ++i) {
                    certs[i] = NX509Certificate.decodeFromString((String)chain[i]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            keyStore.setKeyEntry(req.getString("alias"), key, password, certs);
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public int keyStoreSize(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("keystore.size");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("size");
    }

    private FoxResponse keyStoreSize(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        resp.add("size", keyStore.size());
        return resp;
    }

    public void keyStoreSave(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("keystore.save");
        req.add("cryptoStoreId", id.toString());
        this.sendSync(req);
    }

    private FoxResponse keyStoreSave(FoxRequest req) throws Exception {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        keyStore.save();
        return resp;
    }

    public Enumeration<NX509CertificateEntry> keyStoreGetCertificates(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("keystore.getCertificates");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        String[] certs = resp.listStrings("cert");
        Array entries = new Array(NX509CertificateEntry.class);
        for (String cert : certs) {
            NX509CertificateEntry entry = NX509CertificateEntry.decodeFromString((String)cert);
            entries.add((Object)entry);
        }
        return Collections.enumeration(entries.list());
    }

    private FoxResponse keyStoreGetCertificates(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        Enumeration e = keyStore.getCertificates();
        while (e.hasMoreElements()) {
            NX509CertificateEntry entry = (NX509CertificateEntry)e.nextElement();
            resp.add("cert", entry.encodeToString());
        }
        return resp;
    }

    public String keyStoreFindCertificate(CryptoStoreId id, X509Certificate cert) throws Exception {
        FoxRequest req = this.makeRequest("keystore.findCertificate");
        req.add("cryptoStoreId", id.toString());
        req.add("certificate", NX509Certificate.encodeToString((X509Certificate)cert));
        FoxResponse resp = this.sendSync(req);
        return resp.getString("alias", null);
    }

    private FoxResponse keyStoreFindCertificate(FoxRequest req) throws Exception {
        X509Certificate match;
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        String alias = keyStore.findCertificate(match = NX509Certificate.decodeFromString((String)req.getString("certificate")));
        if (alias != null) {
            resp.add("alias", alias);
        }
        return resp;
    }

    public void keyStoreDeleteEntries(CryptoStoreId id, String[] aliases) throws Exception {
        FoxRequest req = this.makeRequest("keystore.deleteEntries");
        req.add("cryptoStoreId", id.toString());
        for (String aliase : aliases) {
            req.add("alias", aliase);
        }
        this.sendSync(req);
    }

    private FoxResponse keyStoreDeleteEntries(FoxRequest req) throws Exception {
        String[] aliases;
        BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        if (id == CryptoStoreId.USER_EXEMPTION_STORE) {
            throw new IllegalArgumentException("Invalid store id passed to keyStoreDeleteEntries: " + id);
        }
        if (id == CryptoStoreId.USER_TRUST_STORE) {
            this.checkSuperUser(LEX.getText("cert.userTrustStore.deleteCommand", this.getSessionContext()));
        } else {
            BCryptoChannel.checkUserPermissions(BPermissions.adminInvoke);
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreTrustStore keyStore = (ICoreTrustStore)this.getCorrectCryptoStore(req);
        for (String aliase : aliases = req.listStrings("alias")) {
            this.log.trace("deleting entry " + aliase);
            keyStore.deleteEntry(aliase);
        }
        return resp;
    }

    public int mgrGenerateSelfSignedCert(NCertificateParameters certParams) throws Exception {
        FoxRequest req = this.makeRequest("mgr.generateSelfSignedCert");
        String certParamString = this.encrypt(certParams.encodeToString(), this.makeEncodingContext(null));
        req.add("certParams", certParamString);
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("requestId", -1);
    }

    private FoxResponse mgrGenerateSelfSignedCert(FoxRequest req) throws Exception {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxResponse resp = new FoxResponse(req);
        String certParamsStr = req.getString("certParams");
        certParamsStr = this.decryptToString(certParamsStr, this.makeDecodingContext(null));
        NCertificateParameters certParams = new NCertificateParameters(certParamsStr);
        int requestId = this.service.generateSelfSignedCert(certParams);
        resp.add("requestId", requestId);
        return resp;
    }

    public int mgrGetCertGenerationStatus(int requestId) throws Exception {
        FoxRequest req = this.makeRequest("mgr.getCertGenerationStatus");
        req.add("requestId", requestId);
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("status", -1);
    }

    private FoxResponse mgrGetCertGenerationStatus(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        int requestId = req.getInt("requestId", -1);
        int status = this.service.getCertGenerationStatus(requestId);
        resp.add("requestId", requestId);
        resp.add("status", status);
        return resp;
    }

    public NPKCS10CertificationRequest keyStoreGenerateCSR(String alias, String passwd) throws Exception {
        FoxRequest req = this.makeRequest("keystore.generateCSR");
        req.add("alias", alias);
        if (passwd != null) {
            req.add("passwd", this.encrypt(passwd, this.makeEncodingContext(null)));
        }
        FoxResponse resp = this.sendSync(req);
        return NPKCS10CertificationRequest.make((String)resp.getString("csr"));
    }

    private FoxResponse keyStoreGenerateCSR(FoxRequest req) throws Exception {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxResponse resp = new FoxResponse(req);
        String alias = req.getString("alias");
        String passwd = this.decryptToString(req.getString("passwd", null), this.makeDecodingContext(null));
        NPKCS10CertificationRequest csr = this.service.generateCSR(alias, passwd);
        resp.add("csr", csr.encodeToString());
        return resp;
    }

    public Enumeration<NProvider> providerProviders() throws Exception {
        String[] tproviders;
        FoxRequest req = this.makeRequest("provider.Providers");
        FoxResponse resp = this.sendSync(req);
        Vector<NProvider> providers = new Vector<NProvider>();
        for (String tprovider : tproviders = resp.listStrings("provider")) {
            providers.add(NProvider.decodeFromString((String)tprovider));
        }
        return providers.elements();
    }

    private FoxResponse providerProviders(FoxRequest req) throws Exception {
        NProvider[] providers;
        FoxResponse resp = new FoxResponse(req);
        for (NProvider provider : providers = NProvider.getProviders()) {
            resp.add("provider", provider.encodeToString());
        }
        return resp;
    }

    public IProvider providerGetProvider(String name) throws Exception {
        FoxRequest req = this.makeRequest("provider.getProvider");
        req.add("name", name);
        FoxResponse resp = this.sendSync(req);
        return NProvider.decodeFromString((String)resp.getString("provider"));
    }

    private FoxResponse providerGetProvider(FoxRequest req) throws Exception {
        NProvider[] providers;
        FoxResponse resp = new FoxResponse(req);
        for (NProvider provider : providers = NProvider.getProviders()) {
            resp.add("provider", provider.encodeToString());
        }
        return resp;
    }

    public Enumeration<NHostExemption> exemptionExemptions() throws Exception {
        FoxRequest req = this.makeRequest("exemption.exemptions");
        FoxResponse resp = this.sendSync(req);
        String[] exemptionStrings = resp.listStrings("exemption");
        Array exemptions = new Array(NHostExemption.class);
        for (String exemptionString : exemptionStrings) {
            exemptions.push((Object)NHostExemption.decodeFromString((String)exemptionString));
        }
        return Collections.enumeration(exemptions.list());
    }

    private FoxResponse exemptionExemptions(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        Enumeration e = mgr.exemptions();
        while (e.hasMoreElements()) {
            NHostExemption exemption = (NHostExemption)e.nextElement();
            resp.add("exemption", exemption.encodeToString());
        }
        return resp;
    }

    public void exemptionSetExemption(NHostExemption exemption) throws Exception {
        FoxRequest req = this.makeRequest("exemption.setExemption");
        req.add("exemption", exemption.encodeToString());
        this.sendSync(req);
    }

    private FoxResponse exemptionSetExemption(FoxRequest req) throws Exception {
        NHostExemption exemption = NHostExemption.make((String)req.getString("exemption"));
        if (exemption.getApproved()) {
            this.checkSuperUser(LEX.getText("cert.exemptionStore.approveCommand", this.getSessionContext()));
        } else {
            this.checkSuperUser(LEX.getText("cert.exemptionStore.unapproveCommand", this.getSessionContext()));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        mgr.setExemption(exemption);
        return resp;
    }

    public void exemptionDeleteExemption(String host) throws Exception {
        FoxRequest req = this.makeRequest("exemption.deleteExemption");
        req.add("host", host);
        this.sendSync(req);
    }

    private FoxResponse exemptionDeleteExemption(FoxRequest req) throws Exception {
        this.checkSuperUser(LEX.getText("cert.exemptionStore.deleteCommand", this.getSessionContext()));
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        String host = req.getString("host");
        mgr.deleteExemption(host);
        return resp;
    }

    public NHostExemption exemptionGetExemption(String host) throws Exception {
        FoxRequest req = this.makeRequest("exemption.getExemption");
        req.add("host", host);
        FoxResponse resp = this.sendSync(req);
        String exemptString = resp.getString("exemption");
        return NHostExemption.make((String)exemptString);
    }

    private FoxResponse exemptionGetExemption(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        String host = req.getString("host");
        NHostExemption exemption = mgr.getExemption(host);
        resp.add("exemption", exemption.encodeToString());
        return resp;
    }

    public void exemptionSave() throws Exception {
        FoxRequest req = this.makeRequest("exemption.save");
        this.sendSync(req);
    }

    private FoxResponse exemptionSave(FoxRequest req) throws Exception {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxResponse resp = new FoxResponse(req);
        ICoreExemptionStore mgr = this.service.getExemptionStore();
        mgr.save();
        return resp;
    }

    public boolean storeIsReadOnly(CryptoStoreId id) throws Exception {
        FoxRequest req = this.makeRequest("store.isReadOnly");
        req.add("cryptoStoreId", id.toString());
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("isReadOnly", true);
    }

    private FoxResponse storeIsReadOnly(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        ICoreStore store = this.getCorrectCryptoStore(req);
        resp.add("isReadOnly", store.isReadOnly());
        return resp;
    }

    private ICoreStore getCorrectCryptoStore(FoxRequest req) throws Exception {
        CryptoStoreId id = CryptoStoreId.getEnum((String)req.getString("cryptoStoreId"));
        switch (id) {
            case USER_KEY_STORE: {
                return this.service.getKeyStore();
            }
            case USER_TRUST_STORE: {
                return this.service.getUserTrustStore();
            }
            case USER_UNTRUSTED_STORE: {
                return this.service.getUserUntrustedStore();
            }
            case SYSTEM_TRUST_STORE: {
                return this.service.getSystemTrustStore();
            }
            case USER_EXEMPTION_STORE: {
                return this.service.getExemptionStore();
            }
        }
        throw new IllegalArgumentException("invalid key store location provided");
    }

    public File getBaseDir() {
        try {
            return new File(BCryptoChannel.getFilePath(BOrd.make((String)"file:~")));
        }
        catch (Exception e) {
            return Sys.getNiagaraHome();
        }
    }

    private static String getFilePath(BOrd ord) throws IOException {
        OrdQuery[] o = ord.parse();
        FilePath p = (FilePath)o[o.length - 1];
        File f = BFileSystem.INSTANCE.pathToLocalFile(p);
        return f.getPath();
    }

    private String encrypt(String secret, Context cx) throws Exception {
        if (secret == null) {
            return null;
        }
        return this.encrypt(SecretBytes.fromString((String)secret), cx);
    }

    private String encrypt(SecretBytes secret, Context cx) throws Exception {
        PasswordEncodingContext pContext = PasswordEncodingContext.from((Context)cx);
        if (pContext.getDecryptionKeySource() == EncryptionKeySource.none) {
            throw new MissingEncodingKeyException();
        }
        return AccessController.doPrivileged(() -> {
            try {
                if (!(this.encryptionAlgorithmBundle instanceof AesAlgorithmBundle)) {
                    throw new SecurityException("Invalid algorithm bundle: " + this.encryptionAlgorithmBundle.getAlgorithmName());
                }
                AesAlgorithmBundle bundle = this.encryptionAlgorithmBundle.getAlgorithmVersion().equals("1") ? AesAlgorithmBundle.make((int)256, (String)"1") : (AesAlgorithmBundle)this.encryptionAlgorithmBundle;
                byte[] iv = new byte[16];
                new SecureRandom().nextBytes(iv);
                String aesTransformation = bundle.getAesTransformation();
                byte[] key = ((SecretBytes)((ISecretBytesSupplier)pContext.getEncryptionKey().get()).get()).get();
                byte[] cipher = Aes256PasswordManager.encrypt((byte[])secret.get(), (byte[])iv, (byte[])key, (String)aesTransformation);
                String[] data = new String[]{ByteArrayUtil.toHexString((byte[])iv), ByteArrayUtil.toHexString((byte[])cipher)};
                return bundle.encode(data);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private String decryptToString(String encrypted, Context cx) throws Exception {
        SecretBytes decrypted = this.decrypt(encrypted, cx);
        if (decrypted == null) {
            return null;
        }
        return decrypted.asString(true, StandardCharsets.UTF_8);
    }

    private SecretBytes decrypt(String encrypted, Context cx) throws Exception {
        if (encrypted == null) {
            return null;
        }
        PasswordEncodingContext pContext = PasswordEncodingContext.from((Context)cx);
        if (pContext.getDecryptionKeySource() == EncryptionKeySource.none) {
            throw new MissingEncodingKeyException();
        }
        return AccessController.doPrivileged(() -> {
            try {
                CryptographicAlgorithmBundle algorithmBundle = CryptographicAlgorithmBundle.getInstanceFor((String)encrypted);
                if (!(algorithmBundle instanceof AesAlgorithmBundle)) {
                    throw new SecurityException("Invalid algorithm bundle: " + algorithmBundle.getAlgorithmName());
                }
                String[] data = algorithmBundle.decode(encrypted);
                Objects.requireNonNull(data);
                String iv = data[0];
                byte[] ivBytes = ByteArrayUtil.hexStringToBytes((String)iv);
                String cipher = data[1];
                byte[] cipherBytes = ByteArrayUtil.hexStringToBytes((String)cipher);
                return Aes256PasswordManager.decryptSecret((byte[])((SecretBytes)((ISecretBytesSupplier)pContext.getDecryptionKey().get()).get()).get(), (byte[])cipherBytes, (byte[])ivBytes, (String)((AesAlgorithmBundle)algorithmBundle).getAesTransformation());
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private static void checkUserPermissions(BPermissions requiredPermissions) {
        BCertManagerService cms = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)cms);
        if (!perms.has(requiredPermissions)) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + requiredPermissions.toString(null));
        }
    }

    private void checkSuperUser(String commandName) {
        BUser authenticatedUser = BUser.getCurrentAuthenticatedUser();
        if (authenticatedUser != null && authenticatedUser.getPermissions().isSuperUser()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LEX.getText("cert.userTrustStore.superUserPermissionException", null, new Object[]{commandName}));
        }
        throw new PermissionException(LEX.getText("cert.userTrustStore.superUserPermissionException", this.getSessionContext(), new Object[]{commandName}));
    }
}

