/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.net.HttpUtil;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.xml.XWriter;

public class SetKeyEntryMessage
extends KeyStoreMessage {
    private String alias;
    private Key key;
    private byte[] rawKey;
    private SecretChars password = null;
    private X509Certificate[] chain;

    public SetKeyEntryMessage(String keyStoreType, String alias, byte[] key, X509Certificate[] chain, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.add("alias", alias);
        this.alias = alias;
        this.chain = chain;
        this.rawKey = key;
        this.password = null;
        this.sharedSecretKey = sharedSecretKey;
    }

    public SetKeyEntryMessage(String keyStoreType, String alias, Key key, char[] password, X509Certificate[] chain, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.add("alias", alias);
        this.alias = alias;
        this.chain = chain;
        this.key = key;
        if (password != null) {
            this.password = new SecretChars(password, false);
        }
        this.sharedSecretKey = sharedSecretKey;
    }

    @Override
    public String getAction() {
        return "setKeyEntry";
    }

    public String getMethod() {
        return "POST";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) {
        block26: {
            this.add("sharedKeyName", this.sharedSecretKey.getName());
            if (this.password != null && this.password.size() > 0) {
                String encodedPassword = this.prepareMessage(this.password, this.sharedSecretKey);
                encodedPassword = HttpUtil.decodeUrl((String)encodedPassword);
                this.add("passwd", encodedPassword);
                this.password.close();
                this.password = null;
            }
            XWriter xml = null;
            try {
                xml = new XWriter(out);
                xml.w((Object)"<keyEntry ").attr("alias", this.alias);
                xml.w((Object)" >").w((Object)"<key >");
                if (this.rawKey != null) {
                    try (SecretBytes secretBytes = new SecretBytes(this.rawKey, true);){
                        xml.w((Object)Base64.getEncoder().encode(this.sharedSecretKey.encrypt(secretBytes)));
                    }
                }
                if (this.key != null) {
                    try {
                        xml.w((Object)HttpUtil.decodeUrl((String)this.prepareMessage(NKey.encodeToString((Key)this.key), this.sharedSecretKey)));
                    }
                    catch (Exception secretBytes) {
                        // empty catch block
                    }
                }
                xml.w((Object)"</key>");
                if (this.chain == null || this.chain.length <= 0) break block26;
                xml.w((Object)"<certChain>");
                for (int i = 0; i < this.chain.length; ++i) {
                    xml.w((Object)"<certificate>");
                    try {
                        xml.w((Object)NX509Certificate.encodeToString((X509Certificate)this.chain[i]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    xml.w((Object)"</certificate>");
                }
                xml.w((Object)"</certChain>").w((Object)"</keyEntry>");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (xml != null) {
                    xml.flush();
                    xml.close();
                }
            }
        }
    }
}

