/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import javax.baja.xml.XWriter;

public class SetCertificateEntryMessage
extends KeyStoreMessage {
    private String alias;
    private X509Certificate cert;

    public SetCertificateEntryMessage(String keyStoreType, String alias, X509Certificate cert) {
        super(keyStoreType);
        this.add("alias", alias);
        this.alias = alias;
        this.cert = cert;
    }

    @Override
    public String getAction() {
        return "setCertificateEntry";
    }

    public String getMethod() {
        return "POST";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream output) {
        XWriter out = null;
        try {
            out = new XWriter(output);
            out.w((Object)"<certificate ");
            if (this.alias != null) {
                out.attr("alias", this.alias);
            }
            out.w((Object)" >");
            out.w((Object)NX509Certificate.encodeToString((X509Certificate)this.cert));
            out.w((Object)"</certificate>");
            out.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

