/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.EncryptableDaemonMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.baja.nre.security.SharedSecretKey;

public class CryptoServletMessage
extends DaemonMessage
implements EncryptableDaemonMessage {
    private StringBuilder message = new StringBuilder("crypto");
    private static final String ENC = "UTF-8";
    protected SharedSecretKey sharedSecretKey;

    public CryptoServletMessage() {
        this.message.append("?action=").append(this.getAction());
    }

    public String getAction() {
        return "sendAliases";
    }

    public boolean isStateChangeMessage() {
        return false;
    }

    public String getMessageString() {
        return this.message.toString();
    }

    protected void add(String key, String value) {
        this.add(key, value, EncodingMask.key_and_value);
    }

    protected void add(String key, String value, EncodingMask mask) {
        switch (mask) {
            case none: {
                this.message.append("&").append(key).append("=").append(value);
                break;
            }
            case key: {
                this.message.append("&").append(CryptoServletMessage.encode(key)).append("=").append(value);
                break;
            }
            case value: {
                this.message.append("&").append(key).append("=").append(CryptoServletMessage.encode(value));
                break;
            }
            case key_and_value: {
                this.message.append("&").append(CryptoServletMessage.encode(key)).append("=").append(CryptoServletMessage.encode(value));
            }
        }
    }

    private static String encode(String plain) {
        String encoded = "";
        if (plain != null) {
            try {
                encoded = URLEncoder.encode(plain, ENC);
            }
            catch (UnsupportedEncodingException e) {
                encoded = URLEncoder.encode(plain);
            }
        }
        return encoded;
    }

    public boolean requiresSharedKey() {
        return false;
    }

    public void setSharedKey(SharedSecretKey sharedSecretKey) {
        this.sharedSecretKey = sharedSecretKey;
    }

    public static enum EncodingMask {
        none,
        key,
        value,
        key_and_value;

    }
}

