/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreProviderInfo;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.BDaemonPlatform;
import com.tridium.platcrypto.daemon.BPlatCryptoBase;
import com.tridium.platcrypto.daemon.BPlatExemptionStore;
import com.tridium.platcrypto.daemon.BPlatKeyStore;
import com.tridium.platcrypto.daemon.BPlatProviderInfo;
import com.tridium.platcrypto.daemon.BPlatTrustStore;
import com.tridium.platcrypto.daemon.messages.CertGenerationStatusMessage;
import com.tridium.platcrypto.daemon.messages.GenerateCertificateMessage;
import com.tridium.platcrypto.daemon.messages.GenerateCsrMessage;
import com.tridium.platcrypto.daemon.messages.SendAliasesMessage;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import java.io.InputStream;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
public class BPlatCryptoManager
extends BPlatCryptoBase
implements ICoreCryptoManager {
    public static final Type TYPE = Sys.loadType(BPlatCryptoManager.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String USER_KEY_STORE = "userKeyStore";
    public static final String USER_TRUST_STORE = "userTrustStore";
    public static final String USER_UNTRUSTED_STORE = "userUntrustedStore";
    public static final String SYSTEM_TRUST_STORE = "systemTrustStore";

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPlatCryptoManager() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BPlatCryptoManager(BDaemonSession session) {
        super(session);
    }

    public static BPlatCryptoManager make(BDaemonPlatform platform) {
        if (platform != null && platform.getDaemonSession() != null) {
            return new BPlatCryptoManager(platform.getDaemonSession());
        }
        return null;
    }

    public ICoreExemptionStore getExemptionStore() throws Exception {
        return new BPlatExemptionStore(this.getDaemonSession());
    }

    public ICoreKeyStore getKeyStore() throws Exception {
        return new BPlatKeyStore(this.getDaemonSession());
    }

    public ICoreTrustStore getUserTrustStore() throws Exception {
        return new BPlatTrustStore(this.getDaemonSession(), USER_TRUST_STORE);
    }

    public ICoreTrustStore getUserUntrustedStore() throws Exception {
        return new BPlatTrustStore(this.getDaemonSession(), USER_UNTRUSTED_STORE);
    }

    public ICoreTrustStore getSystemTrustStore() throws Exception {
        return new BPlatTrustStore(this.getDaemonSession(), SYSTEM_TRUST_STORE);
    }

    private BPlatKeyStore getPlatKeyStore() throws Exception {
        return new BPlatKeyStore(this.getDaemonSession());
    }

    public ICoreProviderInfo getProviderInfo() throws Exception {
        return new BPlatProviderInfo(this.getDaemonSession());
    }

    public boolean isSecure() {
        return this.getDaemonSession().isSecure();
    }

    public int generateSelfSignedCert(NCertificateParameters certParams) throws Exception {
        XElem request = this.send(new GenerateCertificateMessage(this.getPlatKeyStore().getKeyStoreType(), certParams, this.getDaemonSession().generateSharedSecretKey("generateCertificate")));
        if (request != null) {
            return request.geti("requestId", -1);
        }
        return -1;
    }

    public int getCertGenerationStatus(int requestId) throws Exception {
        XElem stat = this.send(new CertGenerationStatusMessage(this.getPlatKeyStore().getKeyStoreType(), requestId));
        if (stat != null) {
            return stat.geti("status", -1);
        }
        return -1;
    }

    public NPKCS10CertificationRequest generateCSR(String alias, String passwd) throws Exception {
        XElem csr = this.send(new GenerateCsrMessage(this.getPlatKeyStore().getKeyStoreType(), alias, passwd, this.getDaemonSession().generateSharedSecretKey("generateCSR")));
        if (csr != null && csr.text() != null) {
            String csrText = csr.text().toString();
            return NPKCS10CertificationRequest.make((String)csrText);
        }
        return null;
    }

    public boolean canGenerateCertificate() {
        boolean canGenerate = false;
        try {
            BDaemonSession daemonSession = this.getDaemonSession();
            if (daemonSession.getHostProperties().supportsServlet("crypto")) {
                String osPartName;
                InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new SendAliasesMessage(this.getPlatKeyStore().getKeyStoreType()));
                XElem keyStore = XParser.make((InputStream)in).parse();
                canGenerate = keyStore.attrIndex("canGenerate") != -1 ? keyStore.getb("canGenerate", false) : !(osPartName = daemonSession.getHostProperties().getOsName()).startsWith("qnx-jace") || !osPartName.startsWith("tridium-qnx7") || !BStationSurrogate.isAnyStationRunning((BDaemonSession)daemonSession);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return canGenerate;
    }
}

