/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.wb;

import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridiumX.knxnetIp.wb.BDiscoverDevicesOptions;
import com.tridiumX.knxnetIp.wb.BImportEtsProjectFilePane;
import com.tridiumX.knxnetIp.wb.BKnxWbService;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="discoverDevicesSelected"), @NiagaraAction(name="importDevicesSelected")})
public class BDiscoverDevicesPane
extends BEdgePane {
    public static final Action discoverDevicesSelected = BDiscoverDevicesPane.newAction((int)0, null);
    public static final Action importDevicesSelected = BDiscoverDevicesPane.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDiscoverDevicesPane.class);
    private final ToggleCommandGroup<ToggleCommand> toggleDataSource = new ToggleCommandGroup();
    private final BRadioButton discoverDevices = new BRadioButton(this.toggleDataSource, lex.get("discoverDevices.label", "Search network for Devices :"));
    private final BRadioButton importDevices = new BRadioButton(this.toggleDataSource, lex.get("importDevices.label", "Import Devices from cache/file :"));
    private final BLabel knxInstallationToSearchLbl = new BLabel(lex.get("knxInstallationToSearch.label", "'Knx Installation' to search :"));
    private final BFrozenEnumFE knxInstallationToSearch = new BFrozenEnumFE();
    private final BImportEtsProjectFilePane importPane = new BImportEtsProjectFilePane(false);
    private static final Lexicon lex = Lexicon.make(BImportEtsProjectFilePane.class);

    public void discoverDevicesSelected() {
        this.invoke(discoverDevicesSelected, null, null);
    }

    public void importDevicesSelected() {
        this.invoke(importDevicesSelected, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDiscoverDevicesPane() {
    }

    public BDiscoverDevicesPane(BDynamicEnum knxInstallationsEnum, boolean importOnly) {
        if (!importOnly) {
            if (knxInstallationsEnum != null && knxInstallationsEnum.getRange().getOrdinals().length > 0) {
                this.discoverDevices.setEnabled(true);
                if (BKnxWbService.getImportSettings().getLastDevicesDiscoveryFromNetwork()) {
                    this.discoverDevices.setSelected(true);
                } else {
                    this.importDevices.setSelected(true);
                }
                this.knxInstallationToSearch.loadValue((BObject)knxInstallationsEnum);
                this.knxInstallationToSearch.setEnabled(true);
            } else {
                this.discoverDevices.setEnabled(false);
                this.knxInstallationToSearch.setEnabled(false);
                this.importDevices.setSelected(true);
            }
        } else {
            this.importDevices.setSelected(true);
        }
        this.updateControls();
        if (!importOnly) {
            this.linkTo((BComponent)this.discoverDevices, (Slot)BRadioButton.selected, (Slot)discoverDevicesSelected);
            this.linkTo((BComponent)this.importDevices, (Slot)BRadioButton.selected, (Slot)importDevicesSelected);
        }
        BInsets insets = null;
        BGridPane grid = new BGridPane(1);
        if (!importOnly) {
            grid.add("discoverDevices", (BValue)this.discoverDevices);
            BGridPane innerGrid = new BGridPane(2);
            innerGrid.add("lbl", (BValue)this.knxInstallationToSearchLbl);
            innerGrid.add("fe", (BValue)this.knxInstallationToSearch);
            insets = BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)20.0);
            BBorderPane borderPane = new BBorderPane((BWidget)innerGrid, insets);
            grid.add("knxInstallations", (BValue)borderPane);
            grid.add("importDevices", (BValue)this.importDevices);
        }
        if (insets == null) {
            grid.add("importPane", (BValue)this.importPane);
        } else {
            grid.add("importPane", (BValue)new BBorderPane((BWidget)this.importPane, insets));
        }
        this.setTop((BWidget)grid);
    }

    public void doDiscoverDevicesSelected() {
        this.updateControls();
    }

    public void doImportDevicesSelected() {
        this.updateControls();
    }

    private void updateControls() {
        boolean discoverSelected = this.discoverDevices.getSelected();
        this.knxInstallationToSearchLbl.setEnabled(discoverSelected);
        this.knxInstallationToSearch.setReadonly(!discoverSelected);
        this.knxInstallationToSearch.setEnabled(discoverSelected);
        this.importPane.setEnabled(!discoverSelected);
    }

    public BDiscoverDevicesOptions getImportOptions() {
        BDiscoverDevicesOptions result = new BDiscoverDevicesOptions();
        result.setDiscoverDevices(this.discoverDevices.isSelected());
        try {
            BDynamicEnum knxInstallationEnum = (BDynamicEnum)this.knxInstallationToSearch.saveValue();
            if (knxInstallationEnum != null) {
                result.setKnxInstallation(knxInstallationEnum);
            }
        }
        catch (CannotSaveException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        result.setImportOptions(this.importPane.getImportOptions());
        return result;
    }
}

